/*
 * Decompiled with CFR 0.152.
 */
package promela.types;

import java.util.List;
import promela.types.IncomparableTypesException;
import promela.types.NumericType;
import promela.types.TypeVariableType;
import promela.types.UnsignedNumericType;

public abstract class Type {
    public abstract String name();

    public abstract boolean equal(Type var1);

    public boolean isSubtype(Type t) {
        return this.equal(t);
    }

    public Type findRecTypeConstructor(TypeVariableType tv) {
        return null;
    }

    public Type skipRecursion(Type outer) {
        return this;
    }

    public boolean isDistinguishableFrom(Type t, Type outer, List numbering, boolean[][] distinguishable) {
        return false;
    }

    public boolean isDistinguishableFrom(Type t) {
        return !this.equal(t);
    }

    public static Type max(Type t1, Type t2) throws IncomparableTypesException {
        if (Type.comparingBitWithUnsigned1(t1, t2)) {
            return new NumericType(0);
        }
        if (Type.comparingByteWithUnsigned8(t1, t2)) {
            return new NumericType(1);
        }
        if (t1.isSubtype(t2)) {
            return t2;
        }
        if (t2.isSubtype(t1)) {
            return t1;
        }
        throw new IncomparableTypesException(t1, t2);
    }

    public static Type min(Type t1, Type t2) throws IncomparableTypesException {
        if (Type.comparingBitWithUnsigned1(t1, t2)) {
            return new NumericType(0);
        }
        if (Type.comparingByteWithUnsigned8(t1, t2)) {
            return new NumericType(1);
        }
        if (t1.isSubtype(t2)) {
            return t1;
        }
        if (t2.isSubtype(t1)) {
            return t2;
        }
        throw new IncomparableTypesException(t1, t2);
    }

    private static boolean comparingByteWithUnsigned8(Type t1, Type t2) {
        return t1.equal(new NumericType(1)) && t2.equal(new UnsignedNumericType(8)) || t2.equal(new NumericType(1)) && t1.equal(new UnsignedNumericType(8));
    }

    private static boolean comparingBitWithUnsigned1(Type t1, Type t2) {
        return t1.equal(new NumericType(0)) && t2.equal(new UnsignedNumericType(1)) || t2.equal(new NumericType(0)) && t1.equal(new UnsignedNumericType(1));
    }
}

