/*
 * Decompiled with CFR 0.152.
 */
package promela.types;

import java.util.ArrayList;
import junit.framework.TestCase;
import promela.types.ArrayType;
import promela.types.ChanType;
import promela.types.IncomparableTypesException;
import promela.types.MtypeType;
import promela.types.NumericType;
import promela.types.ProductType;
import promela.types.Type;
import promela.types.UnsignedNumericType;

public class TypeTest
extends TestCase {
    protected void tearDown() throws Exception {
        super.tearDown();
        NumericType.setPidSensitive(false);
    }

    protected Type createByte() {
        return new NumericType(1);
    }

    protected Type createLiteralType(int i) {
        return NumericType.typeOfNumericLiteral(i);
    }

    protected Type createBit() {
        return new NumericType(0);
    }

    protected NumericType createPid() {
        return new NumericType(2);
    }

    protected NumericType createInt() {
        return new NumericType(4);
    }

    public void testMax() throws Exception {
        TypeTest.assertTrue(Type.max(this.createBit(), this.createByte()).equal(this.createByte()));
        TypeTest.assertTrue(Type.max(this.createInt(), this.createByte()).equal(this.createInt()));
        TypeTest.assertTrue(Type.max(this.createBit(), new UnsignedNumericType(1)).equal(Type.max(new UnsignedNumericType(1), this.createBit())));
        TypeTest.assertTrue(Type.max(this.createByte(), new UnsignedNumericType(8)).equal(Type.max(new UnsignedNumericType(8), this.createByte())));
        TypeTest.assertTrue(Type.max(this.createByte(), new UnsignedNumericType(9)).equal(new UnsignedNumericType(9)));
        TypeTest.assertTrue(Type.max(new MtypeType(), new MtypeType()).equal(new MtypeType()));
        try {
            Type.max(new MtypeType(), this.createByte());
            TypeTest.fail();
        }
        catch (IncomparableTypesException incomparableTypesException) {
            // empty catch block
        }
        ArrayType t1 = new ArrayType(this.createByte(), this.createPid(), 4);
        ArrayList<Type> fields = new ArrayList<Type>();
        fields.add(this.createBit());
        fields.add(this.createByte());
        ChanType t2 = new ChanType(new ProductType(fields));
        try {
            Type.max(t1, t2);
            TypeTest.fail();
        }
        catch (IncomparableTypesException incomparableTypesException) {
            // empty catch block
        }
    }

    public void testMin() throws Exception {
        TypeTest.assertTrue(Type.min(this.createBit(), this.createByte()).equal(this.createBit()));
        TypeTest.assertTrue(Type.min(this.createInt(), this.createByte()).equal(this.createByte()));
        TypeTest.assertTrue(Type.min(this.createBit(), new UnsignedNumericType(1)).equal(Type.min(new UnsignedNumericType(1), this.createBit())));
        TypeTest.assertTrue(Type.min(this.createByte(), new UnsignedNumericType(8)).equal(Type.min(new UnsignedNumericType(8), this.createByte())));
        TypeTest.assertTrue(Type.min(this.createByte(), new UnsignedNumericType(9)).equal(this.createByte()));
        TypeTest.assertTrue(Type.min(new MtypeType(), new MtypeType()).equal(new MtypeType()));
        try {
            Type.min(new MtypeType(), this.createByte());
            TypeTest.fail();
        }
        catch (IncomparableTypesException incomparableTypesException) {
            // empty catch block
        }
        ArrayType t1 = new ArrayType(this.createByte(), this.createPid(), 4);
        ArrayList<Type> fields = new ArrayList<Type>();
        fields.add(this.createBit());
        fields.add(this.createByte());
        ChanType t2 = new ChanType(new ProductType(fields));
        try {
            Type.min(t1, t2);
            TypeTest.fail();
        }
        catch (IncomparableTypesException incomparableTypesException) {
            // empty catch block
        }
    }

    protected Type createShort() {
        return new NumericType(3);
    }
}

