/*
 * Decompiled with CFR 0.152.
 */
package promela.types;

import promela.types.BoolType;
import promela.types.NumericType;
import promela.types.Type;

public class UnsignedNumericType
extends NumericType {
    private int noBits;

    public UnsignedNumericType(int width) {
        this.noBits = width;
        long maxValue = (long)Math.pow(2.0, width) - 1L;
        NumericType typeOfMaxValue = UnsignedNumericType.typeOfNumericLiteral(maxValue);
        int i = 0;
        while (i <= 4) {
            this.hasType[i] = typeOfMaxValue.hasType[i];
            ++i;
        }
        if (UnsignedNumericType.isPidSensitive()) {
            this.hasType[2] = false;
        }
    }

    public UnsignedNumericType() {
        this.noBits = -1;
    }

    public NumericType downCast() {
        if (this.noBits < 8) {
            return new NumericType(0);
        }
        return new NumericType(1);
    }

    public boolean equal(Type t) {
        if (!(t instanceof UnsignedNumericType)) {
            return false;
        }
        return this.noBits == ((UnsignedNumericType)t).noBits;
    }

    public String name() {
        return "unsigned:" + this.noBits;
    }

    public boolean isSubtype(Type t) {
        if (t instanceof BoolType && this.noBits == 1) {
            return true;
        }
        if (!(t instanceof NumericType)) {
            return false;
        }
        if (t instanceof UnsignedNumericType) {
            return this.noBits <= ((UnsignedNumericType)t).noBits;
        }
        if (((NumericType)t).hasType[0] && this.noBits == 1) {
            return true;
        }
        if (((NumericType)t).hasType[1] && this.noBits <= 8) {
            return true;
        }
        if (((NumericType)t).hasType[2] && this.noBits <= 8 && !pidSensitive) {
            return true;
        }
        if (((NumericType)t).hasType[3] && this.noBits <= 15) {
            return true;
        }
        return ((NumericType)t).hasType[4] && this.noBits <= 31;
    }

    public boolean isDistinguishableFrom(Type t) {
        if (t instanceof UnsignedNumericType) {
            return this.noBits != ((UnsignedNumericType)t).noBits;
        }
        return super.isDistinguishableFrom(t);
    }
}

