/*
 * Decompiled with CFR 0.152.
 */
package promela.unifier;

import java.util.ArrayList;
import java.util.List;
import promela.types.ArrayType;
import promela.types.ChanType;
import promela.types.ProductType;
import promela.types.RecType;
import promela.types.Type;
import promela.types.TypeVariableFactory;
import promela.types.TypeVariableType;

class Minimiser {
    private static TypeVariableType[] loopNodes;
    private static boolean[] alreadyVisited;
    private static TypeVariableFactory factory;

    static {
        factory = new TypeVariableFactory();
    }

    Minimiser() {
    }

    protected static Type minimise(Type t) {
        List nodeNumbers = Minimiser.assignNumbers(t);
        int[] classes = Minimiser.mark(t, nodeNumbers);
        Minimiser.clearAlreadyVisited(nodeNumbers.size());
        loopNodes = new TypeVariableType[nodeNumbers.size()];
        Minimiser.findLoopNodes(t, classes, nodeNumbers, t);
        Minimiser.clearAlreadyVisited(nodeNumbers.size());
        return Minimiser.minimalForm(t, classes, nodeNumbers, t);
    }

    private static void outputLoopNodes() {
        int i = 0;
        while (i < loopNodes.length) {
            System.out.print(loopNodes[i] + " ");
            ++i;
        }
        System.out.println("");
    }

    private static void outputClasses(int[] classes) {
        int i = 0;
        while (i < classes.length) {
            System.out.print(String.valueOf(classes[i]) + " ");
            ++i;
        }
        System.out.println("");
    }

    private static void clearAlreadyVisited(int size) {
        alreadyVisited = new boolean[size];
        int i = 0;
        while (i < size) {
            Minimiser.alreadyVisited[i] = false;
            ++i;
        }
    }

    private static boolean isGenuineTypeVariable(Type t, Type top) {
        return t instanceof TypeVariableType && t == t.skipRecursion(top);
    }

    private static void findLoopNodes(Type t, int[] classes, List numbers, Type top) {
        if (Minimiser.isGenuineTypeVariable(t, top)) {
            return;
        }
        Type current = t.skipRecursion(top);
        int repNumber = classes[numbers.indexOf(current)];
        if (alreadyVisited[repNumber]) {
            if (loopNodes[repNumber] == null) {
                Minimiser.loopNodes[repNumber] = factory.freshTypeVariable();
            }
            return;
        }
        if (Minimiser.isProductOrChannel(current)) {
            Minimiser.alreadyVisited[repNumber] = true;
        }
        if (current instanceof ArrayType) {
            Minimiser.findLoopNodes(((ArrayType)current).getElementType(), classes, numbers, top);
        } else if (current instanceof ChanType) {
            Minimiser.findLoopNodes(((ChanType)current).getMessageType(), classes, numbers, top);
        } else if (current instanceof ProductType) {
            int j = 0;
            while (j < ((ProductType)current).getArity()) {
                Minimiser.findLoopNodes(((ProductType)current).getTypeOfPosition(j), classes, numbers, top);
                ++j;
            }
        }
    }

    private static boolean isProductOrChannel(Type type) {
        return type instanceof ProductType || type instanceof ChanType;
    }

    private static Type minimalForm(Type t, int[] classes, List numbers, Type top) {
        Type partialResult;
        if (Minimiser.isGenuineTypeVariable(t, top)) {
            return t;
        }
        Type current = t.skipRecursion(top);
        int repNumber = classes[numbers.indexOf(current)];
        if (alreadyVisited[repNumber]) {
            return loopNodes[repNumber];
        }
        if (Minimiser.isProductOrChannel(current)) {
            Minimiser.alreadyVisited[repNumber] = true;
        }
        if ((current = (Type)numbers.get(repNumber)) instanceof ArrayType) {
            partialResult = new ArrayType(Minimiser.minimalForm(((ArrayType)current).getElementType(), classes, numbers, top), ((ArrayType)current).getIndexType(), ((ArrayType)current).getLength());
        } else if (current instanceof ChanType) {
            partialResult = new ChanType(Minimiser.minimalForm(((ChanType)current).getMessageType(), classes, numbers, top));
        } else if (current instanceof ProductType) {
            ArrayList<Type> temp = new ArrayList<Type>();
            int j = 0;
            while (j < ((ProductType)current).getArity()) {
                temp.add(Minimiser.minimalForm(((ProductType)current).getTypeOfPosition(j), classes, numbers, top));
                ++j;
            }
            partialResult = new ProductType(temp);
        } else {
            partialResult = current;
        }
        if (loopNodes[repNumber] != null) {
            return new RecType(loopNodes[repNumber], partialResult);
        }
        return partialResult;
    }

    private static List assignNumbers(Type t) {
        return Minimiser.assignNumbers(t, t, new ArrayList());
    }

    private static List assignNumbers(Type t, Type top, List l) {
        if (l.contains(t)) {
            return l;
        }
        if (t instanceof TypeVariableType && top.findRecTypeConstructor((TypeVariableType)t) != null) {
            return l;
        }
        if (t instanceof RecType) {
            return Minimiser.assignNumbers(((RecType)t).getBody(), top, l);
        }
        l.add(t);
        if (t instanceof ArrayType) {
            l = Minimiser.assignNumbers(((ArrayType)t).getElementType(), top, l);
        }
        if (t instanceof ChanType) {
            l = Minimiser.assignNumbers(((ChanType)t).getMessageType(), top, l);
        }
        if (t instanceof ProductType) {
            int i = 0;
            while (i < ((ProductType)t).getArity()) {
                l = Minimiser.assignNumbers(((ProductType)t).getTypeOfPosition(i), top, l);
                ++i;
            }
            return l;
        }
        return l;
    }

    private static int[] mark(Type t, List nodeNumbers) {
        boolean[][] distinguishable = Minimiser.markImmediatelyDistinguishableNodes(nodeNumbers, t);
        Minimiser.computeFixpointMarking(distinguishable, nodeNumbers, t);
        return Minimiser.assignRepresentatives(distinguishable);
    }

    private static boolean[][] markImmediatelyDistinguishableNodes(List nodeNumbers, Type top) {
        int j;
        boolean[][] distinguishable = new boolean[nodeNumbers.size()][nodeNumbers.size()];
        int i = 0;
        while (i < nodeNumbers.size()) {
            j = i;
            while (j < nodeNumbers.size()) {
                distinguishable[i][j] = ((Type)nodeNumbers.get(i)).isDistinguishableFrom((Type)nodeNumbers.get(j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nodeNumbers.size()) {
            if (nodeNumbers.get(i) instanceof ProductType) {
                j = 0;
                while (j < ((ProductType)nodeNumbers.get(i)).getArity() - 1) {
                    int k = j + 1;
                    while (k < ((ProductType)nodeNumbers.get(i)).getArity()) {
                        int n;
                        int m = nodeNumbers.indexOf(((ProductType)nodeNumbers.get(i)).getTypeOfPosition(j).skipRecursion(top));
                        if (m < (n = nodeNumbers.indexOf(((ProductType)nodeNumbers.get(i)).getTypeOfPosition(k).skipRecursion(top)))) {
                            distinguishable[m][n] = true;
                        } else {
                            distinguishable[n][m] = true;
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return distinguishable;
    }

    private static void computeFixpointMarking(boolean[][] distinguishable, List nodeNumbers, Type t) {
        boolean changedInLastPhase = true;
        while (changedInLastPhase) {
            changedInLastPhase = false;
            int i = 0;
            while (i < nodeNumbers.size()) {
                int j = i + 1;
                while (j < nodeNumbers.size()) {
                    if (!distinguishable[i][j]) {
                        distinguishable[i][j] = ((Type)nodeNumbers.get(i)).isDistinguishableFrom((Type)nodeNumbers.get(j), t, nodeNumbers, distinguishable);
                        changedInLastPhase = distinguishable[i][j] ? true : changedInLastPhase;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static int[] assignRepresentatives(boolean[][] distinguishable) {
        int[] representatives = new int[distinguishable.length];
        int i = 0;
        while (i < representatives.length) {
            representatives[i] = i;
            ++i;
        }
        i = 0;
        while (i < representatives.length) {
            int j = 0;
            while (j < representatives.length) {
                if (i < j && !distinguishable[i][j] && i < representatives[j]) {
                    representatives[j] = i;
                } else if (!distinguishable[j][i] && j < representatives[i]) {
                    representatives[i] = j;
                }
                ++j;
            }
            ++i;
        }
        return representatives;
    }
}

