/*
 * Decompiled with CFR 0.152.
 */
package promela.unifier;

import java.util.ArrayList;
import junit.framework.TestCase;
import promela.types.ChanType;
import promela.types.MtypeType;
import promela.types.NumericType;
import promela.types.ProductType;
import promela.types.RecType;
import promela.types.Type;
import promela.types.TypeVariableFactory;
import promela.types.TypeVariableType;
import promela.unifier.Minimiser;

public class MinimiserTest
extends TestCase {
    public void testMinimise() throws Exception {
        ArrayList<NumericType> l = new ArrayList<NumericType>();
        l.add(new NumericType(1));
        l.add(new NumericType(2));
        ChanType t = new ChanType(l);
        MinimiserTest.assertEquals(t.name(), "chan {byte,pid}");
        MinimiserTest.assertEquals(Minimiser.minimise(t).name(), "chan {byte,pid}");
    }

    public void testMinimiseRecursiveType() throws Exception {
        TypeVariableFactory tvf = new TypeVariableFactory();
        TypeVariableType X = tvf.freshTypeVariable();
        ArrayList<Type> l1 = new ArrayList<Type>();
        l1.add(X);
        l1.add(new NumericType(0));
        ArrayList<Type> l2 = new ArrayList<Type>();
        l2.add(new ChanType(l1));
        l2.add(new NumericType(0));
        RecType type1 = new RecType(X, new ChanType(l2));
        l1 = new ArrayList();
        l1.add(new ChanType(X));
        l1.add(new NumericType(0));
        ChanType type2 = new ChanType(new RecType(X, new ProductType(l1)));
        MinimiserTest.assertTrue(Minimiser.minimise(type1).equal(Minimiser.minimise(type2)));
        l1 = new ArrayList();
        l1.add(X);
        l1.add(new NumericType(0));
        RecType minimum = new RecType(X, new ChanType(l1));
        MinimiserTest.assertTrue(Minimiser.minimise(type1).equal(minimum));
    }

    public void testExampleOfNonRecursiveTypeWhichCausedError() throws Exception {
        ArrayList<MtypeType> l1 = new ArrayList<MtypeType>();
        l1.add(new MtypeType());
        ArrayList<Type> l2 = new ArrayList<Type>();
        l2.add(new MtypeType());
        l2.add(new ChanType(l1));
        ChanType type = new ChanType(l2);
        MinimiserTest.assertEquals(type.name(), Minimiser.minimise(type).name());
    }
}

