/*
 * Decompiled with CFR 0.152.
 */
package promela.unifier;

import java.util.ArrayList;
import java.util.List;
import promela.analysis.DepthFirstAdapter;
import promela.checker.Checker;
import promela.env.ChannelEntry;
import promela.env.VarEntry;
import promela.node.Node;
import promela.node.TName;
import promela.types.Type;
import promela.unifier.TypeGraph;
import promela.unifier.TypeSubstituter;

public class Substituter
extends DepthFirstAdapter {
    private TypeGraph graph;
    private Checker nodeTypes;

    public Substituter(TypeGraph graph) {
        this.graph = graph;
    }

    public String toString() {
        return this.graph.toString();
    }

    public void setTypeInformation(Checker nodeTypes) {
        this.nodeTypes = nodeTypes;
        nodeTypes.getEnv().applySubsitutions(new TypeSubstituter(this.graph));
    }

    public void caseTName(TName node) {
        if (this.nodeTypes.getEnvEntry(node.getText()) instanceof ChannelEntry) {
            VarEntry entry = (VarEntry)this.nodeTypes.getEnvEntry(node.getText());
            Type newType = new TypeSubstituter(this.graph).applySubstitutions(entry.getType());
            entry.setType(newType);
        }
    }

    public void defaultOut(Node node) {
        if (this.nodeTypes.getOut(node) instanceof Type) {
            this.nodeTypes.setOut(node, new TypeSubstituter(this.graph).applySubstitutions((Type)this.nodeTypes.getOut(node)));
        }
        if (this.nodeTypes.getOut(node) instanceof List) {
            this.setOut(node, this.substituteTypeList((List)this.nodeTypes.getOut(node)));
        }
    }

    private List substituteTypeList(List list) {
        ArrayList<Type> newValue = new ArrayList<Type>();
        int i = 0;
        while (i < list.size()) {
            newValue.add(new TypeSubstituter(this.graph).applySubstitutions((Type)list.get(i)));
            ++i;
        }
        return newValue;
    }
}

