/*
 * Decompiled with CFR 0.152.
 */
package promela.unifier;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import promela.error.Error;
import promela.error.IncompatibleRecordTypesError;
import promela.error.IncompatibleTypesError;
import promela.error.MismatchedArgumentsError;
import promela.error.SubtypingError;
import promela.error.UnequalNumericTypesError;
import promela.types.ArrayType;
import promela.types.BoolType;
import promela.types.ChanType;
import promela.types.IncomparableTypesException;
import promela.types.MtypeType;
import promela.types.NumericType;
import promela.types.ProductType;
import promela.types.RecordType;
import promela.types.Type;
import promela.types.TypeVariableType;
import promela.unifier.EqualityConstraint;
import promela.unifier.SubtypingConstraint;
import promela.unifier.TypeSubstituter;

class TypeGraph {
    private Map rep = new HashMap();

    protected TypeGraph() {
    }

    public String toString() {
        String result = "";
        Iterator i = this.rep.keySet().iterator();
        while (i.hasNext()) {
            Type tv = (Type)i.next();
            if (!this.isVariable(tv)) continue;
            result = String.valueOf(result) + tv.name() + " |-> " + this.applySubstitutions(tv) + ";\n";
        }
        return result;
    }

    public String showRep() {
        String result = "";
        Iterator i = this.rep.keySet().iterator();
        while (i.hasNext()) {
            Type tv = (Type)i.next();
            result = String.valueOf(result) + tv.name() + " |-> " + ((Type)this.rep.get(tv)).name() + ";\n";
        }
        return result;
    }

    protected Error unifyConstraint(SubtypingConstraint sc, List equalityConstraints) {
        if (!this.rep.containsKey(sc.getLhs())) {
            this.rep.put(sc.getLhs(), sc.getLhs());
        }
        if (!this.rep.containsKey(sc.getRhs())) {
            this.rep.put(sc.getRhs(), sc.getRhs());
        }
        Type s = this.rep(sc.getLhs());
        Type t = this.rep(sc.getRhs());
        if (this.isVariable(s) && this.isNumeric(t)) {
            return this.unifyVariableSubtypeOfNumericType((TypeVariableType)s, t);
        }
        if (this.isVariable(t) && this.isNumeric(s)) {
            return this.unifyNumericTypeSubtypeOfVariable(s, (TypeVariableType)t);
        }
        equalityConstraints.add(new EqualityConstraint(s, t, sc.getLine()));
        return null;
    }

    protected Error unifyConstraint(Type left, Type right) {
        Type t;
        Type s;
        if (!this.rep.containsKey(left)) {
            this.rep.put(left, left);
        }
        if (!this.rep.containsKey(right)) {
            this.rep.put(right, right);
        }
        if ((s = this.rep(left)) == (t = this.rep(right)) || this.bothMtypes(s, t) || this.bothSubtypesOfBool(s, t)) {
            return null;
        }
        if (this.bothNumericTypes(s, t)) {
            return this.unify((NumericType)s, (NumericType)t);
        }
        if (this.bothRecords(s, t)) {
            return this.unify((RecordType)s, (RecordType)t);
        }
        if (this.bothChannels(s, t)) {
            return this.unify((ChanType)s, (ChanType)t);
        }
        if (this.bothArrays(s, t)) {
            return this.unify((ArrayType)s, (ArrayType)t);
        }
        if (this.bothProducts(s, t)) {
            return this.unify((ProductType)s, (ProductType)t);
        }
        if (this.oneSideVariable(s, t)) {
            return this.union(s, t);
        }
        return new IncompatibleTypesError(this.applySubstitutions(s).name(), this.applySubstitutions(t).name());
    }

    protected Type rep(Type t) {
        if (this.rep.get(t) == null) {
            return t;
        }
        Type previous = t;
        Type current = (Type)this.rep.get(t);
        while (current != previous) {
            previous = current;
            current = (Type)this.rep.get(previous);
        }
        return current;
    }

    private Error unifyNumericTypeSubtypeOfVariable(Type s, TypeVariableType t) {
        if (t.getLower() == null) {
            t.setLower(s);
            return null;
        }
        if (s.isSubtype(t.getLower())) {
            return null;
        }
        if (t.getLower().isSubtype(s)) {
            if (t.getUpper() == null || s.isSubtype(t.getUpper())) {
                t.setLower(s);
                return null;
            }
            return new SubtypingError(s.name(), this.applySubstitutions(t.getUpper()).name());
        }
        return new IncompatibleTypesError(s.name(), this.applySubstitutions(t.getLower()).name());
    }

    private Error unifyVariableSubtypeOfNumericType(TypeVariableType s, Type t) {
        if (s.getUpper() == null) {
            s.setUpper(t);
            return null;
        }
        if (s.getUpper().isSubtype(t)) {
            return null;
        }
        if (t.isSubtype(s.getUpper())) {
            if (s.getLower() == null || s.getLower().isSubtype(t)) {
                s.setUpper(t);
                return null;
            }
            return new SubtypingError(this.applySubstitutions(s.getLower()).name(), t.name());
        }
        return new IncompatibleTypesError(this.applySubstitutions(s.getUpper()).name(), t.name());
    }

    private Error union(Type s, Type t) {
        if (this.isVariable(s) && this.isVariable(t)) {
            return this.recomputeBounds((TypeVariableType)s, (TypeVariableType)t);
        }
        if (this.isVariable(s)) {
            return this.checkBounds((TypeVariableType)s, t);
        }
        if (this.isVariable(t)) {
            return this.checkBounds((TypeVariableType)t, s);
        }
        this.rep.put(t, s);
        return null;
    }

    private Error recomputeBounds(TypeVariableType s, TypeVariableType t) {
        try {
            Type newUpper = this.leastUpperBound(s, t);
            Type newLower = this.greatestLowerBound(s, t);
            if (newLower != null && newUpper != null && !newLower.isSubtype(newUpper)) {
                return new SubtypingError(this.applySubstitutions(newLower).name(), this.applySubstitutions(newUpper).name());
            }
            s.setLower(newLower);
            s.setUpper(newUpper);
            this.rep.put(t, s);
            return null;
        }
        catch (IncomparableTypesException e) {
            return new IncompatibleTypesError(this.applySubstitutions(e.getLeftType()).name(), this.applySubstitutions(e.getRightType()).name());
        }
    }

    private Error checkBounds(TypeVariableType s, Type t) {
        if (s.getLower() != null && !s.getLower().isSubtype(t)) {
            return new SubtypingError(this.applySubstitutions(s.getLower()).name(), this.applySubstitutions(t).name());
        }
        if (s.getUpper() != null && !t.isSubtype(s.getUpper())) {
            return new SubtypingError(this.applySubstitutions(t).name(), this.applySubstitutions(s.getUpper()).name());
        }
        this.rep.put(s, t);
        return null;
    }

    private Type applySubstitutions(Type t) {
        return new TypeSubstituter(this).applySubstitutions(t);
    }

    private Type greatestLowerBound(TypeVariableType s, TypeVariableType t) throws IncomparableTypesException {
        Type newLower = null;
        if (s.getLower() != null && t.getLower() != null) {
            newLower = Type.max(s.getLower(), t.getLower());
        } else if (s.getLower() != null) {
            newLower = s.getLower();
        } else if (t.getLower() != null) {
            newLower = t.getLower();
        }
        return newLower;
    }

    private Type leastUpperBound(TypeVariableType s, TypeVariableType t) throws IncomparableTypesException {
        Type newUpper = null;
        if (s.getUpper() != null && t.getUpper() != null) {
            newUpper = Type.min(s.getUpper(), t.getUpper());
        } else if (s.getUpper() != null) {
            newUpper = s.getUpper();
        } else if (t.getUpper() != null) {
            newUpper = t.getUpper();
        }
        return newUpper;
    }

    private Error unify(NumericType s, NumericType t) {
        if (s.isCompatible(t)) {
            return null;
        }
        return new UnequalNumericTypesError(s.name(), t.name());
    }

    private Error unify(RecordType s, RecordType t) {
        if (s.equal(t)) {
            return null;
        }
        return new IncompatibleRecordTypesError(s.name(), t.name());
    }

    private Error unify(ChanType s, ChanType t) {
        this.union(s, t);
        return this.unifyConstraint(s.getMessageType(), t.getMessageType());
    }

    private Error unify(ArrayType s, ArrayType t) {
        this.union(s, t);
        Error result = this.unifyConstraint(s.getElementType(), t.getElementType());
        if (result == null) {
            result = this.unifyConstraint(s.getIndexType(), t.getIndexType());
        }
        return result;
    }

    private Error unify(ProductType s, ProductType t) {
        if (s.getArity() == t.getArity()) {
            this.union(s, t);
            Error result = null;
            int i = 0;
            while (i < s.getArity() && result == null) {
                result = this.unifyConstraint(s.getTypeOfPosition(i), t.getTypeOfPosition(i));
                ++i;
            }
            return result;
        }
        return new MismatchedArgumentsError(s.getArity(), t.getArity());
    }

    private boolean oneSideVariable(Type s, Type t) {
        return this.isVariable(s) || this.isVariable(t);
    }

    private boolean bothProducts(Type s, Type t) {
        return s instanceof ProductType && t instanceof ProductType;
    }

    private boolean bothArrays(Type s, Type t) {
        return s instanceof ArrayType && t instanceof ArrayType;
    }

    private boolean bothChannels(Type s, Type t) {
        return s instanceof ChanType && t instanceof ChanType;
    }

    private boolean bothRecords(Type s, Type t) {
        return s instanceof RecordType && t instanceof RecordType;
    }

    private boolean bothSubtypesOfBool(Type left, Type right) {
        return (left instanceof BoolType || left instanceof NumericType && ((NumericType)left).isBitType()) && (right instanceof BoolType || right instanceof NumericType && ((NumericType)right).isBitType());
    }

    private boolean bothMtypes(Type s, Type t) {
        return s instanceof MtypeType && t instanceof MtypeType;
    }

    private boolean bothNumericTypes(Type s, Type t) {
        return s instanceof NumericType && t instanceof NumericType;
    }

    private boolean isVariable(Type t) {
        return t instanceof TypeVariableType;
    }

    private boolean isNumeric(Type t) {
        return t instanceof NumericType;
    }
}

