/*
 * Decompiled with CFR 0.152.
 */
package promela.unifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import promela.types.ArrayType;
import promela.types.ChanType;
import promela.types.ProductType;
import promela.types.RecType;
import promela.types.RecordType;
import promela.types.Type;
import promela.types.TypeVariableFactory;
import promela.types.TypeVariableType;
import promela.unifier.Minimiser;
import promela.unifier.TypeGraph;

public class TypeSubstituter {
    private TypeVariableFactory factory;
    private Map isStartOfLoop;
    private TypeGraph typeGraph;

    public TypeSubstituter(TypeGraph typeGraph) {
        this.typeGraph = typeGraph;
    }

    public Type applySubstitutions(Type t) {
        this.isStartOfLoop = new HashMap();
        this.factory = new TypeVariableFactory();
        this.checkForCycles(t);
        return Minimiser.minimise(this.applySubstitutionsRecursive(t));
    }

    private void checkForCycles(Type t) {
        Type tRep = this.typeGraph.rep(t);
        if (this.isStartOfLoop.containsKey(tRep) && !((Boolean)this.isStartOfLoop.get(tRep)).booleanValue()) {
            this.isStartOfLoop.put(tRep, new Boolean(true));
            return;
        }
        this.isStartOfLoop.put(tRep, new Boolean(false));
        if (tRep instanceof ChanType) {
            this.checkForCycles(((ChanType)tRep).getMessageType());
        }
        if (tRep instanceof ArrayType) {
            this.checkForCycles(((ArrayType)tRep).getElementType());
        }
        if (tRep instanceof ProductType) {
            int i = 0;
            while (i < ((ProductType)tRep).getArity()) {
                this.checkForCycles(((ProductType)tRep).getTypeOfPosition(i));
                ++i;
            }
        }
    }

    private Type applySubstitutionsRecursive(Type t) {
        Type tRep = this.typeGraph.rep(t);
        if (tRep instanceof ArrayType) {
            return new ArrayType(this.applySubstitutionsRecursive(((ArrayType)tRep).getElementType()), this.applySubstitutionsRecursive(((ArrayType)tRep).getIndexType()), ((ArrayType)tRep).getLength());
        }
        if (tRep instanceof ChanType) {
            TypeVariableType tv = null;
            if (this.isStartOfLoop.get(tRep) instanceof TypeVariableType) {
                return (TypeVariableType)this.isStartOfLoop.get(tRep);
            }
            if (this.isStartOfLoop.get(tRep) != null && this.isStartOfLoop.get(tRep).equals(new Boolean(true))) {
                tv = this.factory.freshTypeVariable();
                this.isStartOfLoop.put(tRep, tv);
            }
            if (tv == null) {
                return new ChanType(this.applySubstitutionsRecursive(((ChanType)tRep).getMessageType()));
            }
            return new RecType(tv, new ChanType(this.applySubstitutionsRecursive(((ChanType)tRep).getMessageType())));
        }
        if (tRep instanceof ProductType) {
            TypeVariableType tv = null;
            if (this.isStartOfLoop.get(tRep) instanceof TypeVariableType) {
                return (TypeVariableType)this.isStartOfLoop.get(tRep);
            }
            if (this.isStartOfLoop.get(tRep) != null && this.isStartOfLoop.get(tRep).equals(new Boolean(true))) {
                t = this.factory.freshTypeVariable();
                this.isStartOfLoop.put(tRep, tv);
            }
            ArrayList<Type> tuple = new ArrayList<Type>();
            int i = 0;
            while (i < ((ProductType)tRep).getArity()) {
                tuple.add(this.applySubstitutionsRecursive(((ProductType)tRep).getTypeOfPosition(i)));
                ++i;
            }
            if (tv == null) {
                return new ProductType(tuple);
            }
            return new RecType(tv, new ProductType(tuple));
        }
        if (tRep instanceof RecordType) {
            ArrayList<Type> newFieldTypes = new ArrayList<Type>();
            ListIterator iter = ((RecordType)tRep).getFieldNames().listIterator();
            while (iter.hasNext()) {
                String fieldName = (String)iter.next();
                Type fieldType = ((RecordType)tRep).getFieldType(fieldName);
                newFieldTypes.add(this.applySubstitutionsRecursive(fieldType));
            }
            return new RecordType(((RecordType)tRep).getRecordName(), ((RecordType)tRep).getFieldNames(), newFieldTypes);
        }
        return tRep;
    }
}

