/*
 * Decompiled with CFR 0.152.
 */
package src;

import java.io.IOException;
import junit.framework.Assert;
import promela.Check;
import promela.Extract;
import src.UnknownDetectionStrategyException;
import src.UnknownReductionStrategyException;
import symmreducer.Reduce;
import utilities.Config;

public class TopSpin {
    public static void main(String[] args) throws IOException, InterruptedException {
        int argsIndex;
        int localSearchBound;
        boolean localSearchBounded;
        int noConjugates;
        String generatorFilename;
        String reductionStrategy;
        String detectionStrategy;
        String inputFile;
        block32: {
            inputFile = null;
            detectionStrategy = null;
            reductionStrategy = null;
            generatorFilename = null;
            noConjugates = 0;
            localSearchBounded = false;
            boolean useInverses = false;
            boolean minimalGenerators = false;
            localSearchBound = 0;
            argsIndex = 0;
            if (TopSpin.moreArgs(args, 0)) {
                if (TopSpin.isOption(args[0])) {
                    try {
                        detectionStrategy = TopSpin.getDetectionStrategy(args[0]);
                        if (detectionStrategy.equals("manual")) {
                            if (TopSpin.isOption(args[1])) {
                                System.out.println("Manual symmetry reduction strategy specified, but no filename given for group generators");
                                System.exit(1);
                            } else {
                                generatorFilename = args[1];
                                argsIndex = 2;
                            }
                        } else {
                            argsIndex = 1;
                        }
                        if (TopSpin.isConjugatesOption(args[argsIndex])) {
                            if (args.length == argsIndex + 1 || !TopSpin.isNumeric(args[argsIndex + 1])) {
                                System.out.println("Random conjugates option selected, but number of conjugates not given");
                                System.exit(1);
                            } else {
                                noConjugates = Integer.parseInt(args[argsIndex + 1]);
                                argsIndex += 2;
                            }
                        }
                        if (!TopSpin.moreArgs(args, argsIndex) || !TopSpin.isOption(args[argsIndex])) break block32;
                        try {
                            reductionStrategy = TopSpin.getReductionStrategy(args[argsIndex]);
                            if ((reductionStrategy.equals("hillclimbing") || reductionStrategy.equals("annealing")) && TopSpin.moreArgs(args, ++argsIndex)) {
                                if (TopSpin.isNumeric(args[argsIndex])) {
                                    localSearchBounded = true;
                                    localSearchBound = Integer.parseInt(args[argsIndex]);
                                    if (localSearchBound <= 0) {
                                        System.out.println("Bound for local search must be positive");
                                        System.exit(1);
                                    }
                                    ++argsIndex;
                                }
                                if (TopSpin.moreArgs(args, argsIndex)) {
                                    if (TopSpin.isInversesOption(args[argsIndex])) {
                                        useInverses = true;
                                    }
                                    if (TopSpin.isMinimalOption(args[argsIndex])) {
                                        minimalGenerators = true;
                                    } else {
                                        System.out.println("Unknown option \"" + args[0].substring(1) + "\" specified");
                                        System.exit(1);
                                    }
                                    ++argsIndex;
                                }
                            }
                        }
                        catch (UnknownReductionStrategyException e) {
                            System.out.println("Unknown symmetry reduction strategy \"" + args[argsIndex].substring(1) + "\" specified");
                            System.exit(1);
                        }
                    }
                    catch (UnknownDetectionStrategyException e) {
                        System.out.println("Unknown symmetry detection strategy \"" + args[0].substring(1) + "\" specified");
                        System.exit(1);
                    }
                } else {
                    System.out.println("No detection strategy specified");
                    System.exit(1);
                }
            }
        }
        if (argsIndex >= args.length) {
            System.out.println("No filename specified");
            System.exit(1);
        } else {
            inputFile = args[argsIndex];
        }
        System.out.println("Input file: " + inputFile);
        if (detectionStrategy == null) {
            System.out.println("Type check only");
            Assert.assertNull(reductionStrategy);
            Assert.assertNull(generatorFilename);
            Assert.assertEquals(noConjugates, 0);
            Assert.assertFalse(localSearchBounded);
            Assert.assertEquals(localSearchBound, 0);
            new Check(inputFile).isWellTyped(true);
        } else {
            Config.readConfigFile("config");
            System.out.println("Detection strategy: " + detectionStrategy);
            if (generatorFilename != null) {
                Assert.assertEquals(detectionStrategy, "manual");
                System.out.println("Generators given in: " + generatorFilename);
            }
            if (noConjugates > 0) {
                System.out.println("Using " + noConjugates + " random conjugates");
            }
            if (reductionStrategy == null) {
                System.out.println("Detect symmetry only");
                if (detectionStrategy.equals("manual")) {
                    System.out.println("Cannot apply symmetry detection with the \"manaul\" detection strategy");
                    System.exit(1);
                }
                Assert.assertFalse(localSearchBounded);
                Assert.assertEquals(localSearchBound, 0);
                Extract extract = new Extract(inputFile);
                extract.extract(detectionStrategy, noConjugates);
                extract.destroyGAP();
            } else {
                System.out.println("Reduction strategy: " + reductionStrategy);
                if (localSearchBounded) {
                    Assert.assertTrue(reductionStrategy.equals("hillclimbing") || reductionStrategy.equals("annealing"));
                    System.out.println("Local search bounded by " + localSearchBound + " steps");
                }
                Reduce reduce = new Reduce(inputFile);
                if (detectionStrategy.equals("manual")) {
                    reduce.setManaulFilename(generatorFilename);
                }
                reduce.reduce(detectionStrategy, noConjugates, reductionStrategy);
            }
        }
    }

    private static boolean isMinimalOption(String string) {
        return string.substring(1).toLowerCase().equals("minimal");
    }

    private static boolean isInversesOption(String string) {
        return string.substring(1).toLowerCase().equals("inverses");
    }

    private static String getReductionStrategy(String option) throws UnknownReductionStrategyException {
        Assert.assertTrue(TopSpin.isOption(option));
        if (option.substring(1).toLowerCase().equals("fast")) {
            return "fast";
        }
        if (option.substring(1).toLowerCase().equals("enumerate")) {
            return "enumerate";
        }
        if (option.substring(1).toLowerCase().equals("hillclimbing")) {
            return "hillclimbing";
        }
        if (option.substring(1).toLowerCase().equals("annealing")) {
            return "annealing";
        }
        if (option.substring(1).toLowerCase().equals("segment")) {
            return "segment";
        }
        throw new UnknownReductionStrategyException();
    }

    private static boolean moreArgs(String[] args, int argsIndex) {
        return args.length > argsIndex + 1;
    }

    private static boolean isNumeric(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isConjugatesOption(String string) {
        return string.substring(1).toLowerCase().equals("conjugates");
    }

    private static String getDetectionStrategy(String option) throws UnknownDetectionStrategyException {
        Assert.assertTrue(TopSpin.isOption(option));
        if (option.substring(1).toLowerCase().equals("scd")) {
            return "scd";
        }
        if (option.substring(1).toLowerCase().equals("iad")) {
            return "iad";
        }
        if (option.substring(1).toLowerCase().equals("manual")) {
            return "manual";
        }
        throw new UnknownDetectionStrategyException();
    }

    private static boolean isOption(String string) {
        return string.charAt(0) == '-';
    }
}

