/*
 * Decompiled with CFR 0.152.
 */
package symmreducer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import junit.framework.Assert;
import promela.Extract;
import promela.group.Group;
import promela.staticchanneldiagram.StaticChannelDiagramExtractor;
import promela.unifier.Substituter;
import symmreducer.SymmetryApplierTranspositions;
import utilities.CommunicatingProcess;
import utilities.Config;

public class Reduce
extends Extract {
    private static final boolean useTranspositions = true;
    private static final boolean useSimsMethod = true;
    private String manualFilename = null;

    public Reduce(String sourceName) throws IOException {
        super(sourceName);
    }

    public void reduce(String detectionStrategy, int noConjugates, String reductionStrategy) throws IOException {
        StaticChannelDiagramExtractor extractor;
        BufferedWriter bw = CommunicatingProcess.getWriter(this.gap);
        BufferedReader br = CommunicatingProcess.getReader(this.gap);
        if (detectionStrategy.equals("manual")) {
            Assert.assertNotNull(this.manualFilename);
            extractor = new StaticChannelDiagramExtractor();
            if (this.isWellTyped(true)) {
                String line;
                System.out.println("Reparsing source without inlines");
                this.reparseSourceWithoutInlines();
                this.theAST.apply(extractor);
                Substituter substituter = extractor.unify();
                this.applyTypeSubstitutions(extractor, substituter);
                extractor.directedSaucyRepresentation();
                BufferedReader gensReader = new BufferedReader(new FileReader(this.manualFilename));
                String gens = "";
                while ((line = gensReader.readLine()) != null) {
                    StringTokenizer permSplitter = new StringTokenizer(line, "()");
                    while (permSplitter.hasMoreTokens()) {
                        gens = String.valueOf(gens) + "(";
                        StringTokenizer cycleSplitter = new StringTokenizer(permSplitter.nextToken(), " ");
                        while (cycleSplitter.hasMoreTokens()) {
                            String component = cycleSplitter.nextToken();
                            try {
                                Integer.parseInt(component);
                                gens = String.valueOf(gens) + extractor.getSaucyNumber(new Integer(Integer.parseInt(component)));
                            }
                            catch (NumberFormatException e) {
                                gens = String.valueOf(gens) + extractor.getSaucyNumber(component);
                            }
                            if (!cycleSplitter.hasMoreTokens()) continue;
                            gens = String.valueOf(gens) + " ";
                        }
                        gens = String.valueOf(gens) + ")";
                    }
                    gens = String.valueOf(gens) + "\n";
                }
                Group H = Group.createGroupWithSaucyGenerators(gens, extractor);
                bw.write("H := " + H.gapGenerators() + ";\n");
            }
        } else {
            extractor = this.extract(detectionStrategy, noConjugates);
        }
        if (reductionStrategy.equals("fast") || reductionStrategy.equals("segment")) {
            bw.write("ClassifyBest(H,\"groupinfo\"," + extractor.size() + ");\n");
        } else if (reductionStrategy.equals("enumerate")) {
            bw.write("ClassifyEnumerate(H,\"groupinfo\");\n");
        } else if (reductionStrategy.equals("hillclimbing")) {
            bw.write("ClassifyLocalSearch(H,\"groupinfo\");\n");
        }
        bw.write("Size(H);\n");
        bw.write("GeneratorsOfGroup(H);\n");
        bw.flush();
        System.out.println("Size of group: " + br.readLine());
        String groupGenerators = "";
        String temp = br.readLine();
        while (!temp.contains(new String("]"))) {
            groupGenerators = String.valueOf(groupGenerators) + temp;
            temp = br.readLine();
        }
        groupGenerators = String.valueOf(groupGenerators) + temp;
        groupGenerators = this.removeSpaces(groupGenerators);
        String command = Config.isOSWindows() ? "perl \"" + Config.common() + "PreparePan.pl\" \"" + this.sourceName + "\" " + (extractor.getNoProcesses() + 1) + " " + extractor.getStaticChannelNames().size() + " groupinfo " + "true" + " " + "true" + " " + (reductionStrategy == "segment" ? "true" : "false") + " \"" + Config.common() + "\" \" " + groupGenerators + "\"" : "perl " + Config.common() + "PreparePan.pl " + this.sourceName + " " + (extractor.getNoProcesses() + 1) + " " + extractor.getStaticChannelNames().size() + " groupinfo " + "true" + " " + "true" + " " + (reductionStrategy == "segment" ? "true" : "false") + " " + Config.common() + " " + groupGenerators;
        Process perl = Runtime.getRuntime().exec(command);
        try {
            perl.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        new SymmetryApplierTranspositions(extractor, reductionStrategy.equals("segment")).applySymmetry("sympan.c");
    }

    private String removeSpaces(String s) {
        String result = "";
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != ' ') {
                result = String.valueOf(result) + s.charAt(i);
            }
            ++i;
        }
        return result;
    }

    public void setManaulFilename(String manualFilename) {
        this.manualFilename = manualFilename;
    }
}

