/*
 * Decompiled with CFR 0.152.
 */
package symmreducer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import promela.staticchanneldiagram.StaticChannelDiagramExtractor;
import promela.types.ArrayType;
import promela.types.ChanType;
import promela.types.NumericType;
import promela.types.RecType;
import promela.types.RecordType;
import promela.types.Type;
import symmreducer.PidIndexedArrayReference;
import symmreducer.SensitiveVariableReference;

public abstract class SymmetryApplier {
    protected StaticChannelDiagramExtractor typeInfo;
    protected boolean segment;

    public SymmetryApplier(StaticChannelDiagramExtractor typeInfo, boolean segment) {
        this.typeInfo = typeInfo;
        this.segment = segment;
    }

    protected List getSensitivelyIndexedArrayReferences(String name, Type type, String referencePrefix) {
        ArrayList<PidIndexedArrayReference> result;
        block4: {
            block3: {
                result = new ArrayList<PidIndexedArrayReference>();
                if (!this.isArray(type)) break block3;
                if (SymmetryApplier.isPid(((ArrayType)type).getIndexType()) && !SymmetryApplier.isByte(((ArrayType)type).getIndexType())) {
                    result.add(new PidIndexedArrayReference(String.valueOf(referencePrefix) + name, (ArrayType)type));
                }
                int i = 0;
                while (i < ((ArrayType)type).getLength()) {
                    result.addAll(this.getSensitivelyIndexedArrayReferences(String.valueOf(name) + "[" + i + "]", ((ArrayType)type).getElementType(), referencePrefix));
                    ++i;
                }
                break block4;
            }
            if (!this.isRecord(type)) break block4;
            Iterator iter = ((RecordType)type).getFieldNames().iterator();
            while (iter.hasNext()) {
                String fieldName = (String)iter.next();
                result.addAll(this.getSensitivelyIndexedArrayReferences(fieldName, ((RecordType)type).getFieldType(fieldName), String.valueOf(referencePrefix) + name + "."));
            }
        }
        return result;
    }

    protected List getSensitiveVariableReferences(String varName, Type varType, String prefix) {
        ArrayList<SensitiveVariableReference> result;
        block3: {
            block4: {
                block2: {
                    result = new ArrayList<SensitiveVariableReference>();
                    if (!SymmetryApplier.isPid(varType) && !this.isChan(varType)) break block2;
                    result.add(new SensitiveVariableReference(String.valueOf(prefix) + varName, varType));
                    break block3;
                }
                if (!this.isArray(varType)) break block4;
                int i = 0;
                while (i < ((ArrayType)varType).getLength()) {
                    result.addAll(this.getSensitiveVariableReferences(String.valueOf(varName) + "[" + i + "]", ((ArrayType)varType).getElementType(), prefix));
                    ++i;
                }
                break block3;
            }
            if (!this.isRecord(varType)) break block3;
            Iterator iter = ((RecordType)varType).getFieldNames().iterator();
            while (iter.hasNext()) {
                String fieldName = (String)iter.next();
                result.addAll(this.getSensitiveVariableReferences(fieldName, ((RecordType)varType).getFieldType(fieldName), String.valueOf(prefix) + varName + "."));
            }
        }
        return result;
    }

    protected List getInsensitiveVariableReferences(String varName, Type varType, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        if (SymmetryApplier.isPid(varType) || this.isChan(varType)) {
            return result;
        }
        if (this.isArray(varType)) {
            if (SymmetryApplier.isPid(((ArrayType)varType).getIndexType())) {
                return result;
            }
            int i = 0;
            if (i < ((ArrayType)varType).getLength()) {
                result.addAll(this.getInsensitiveVariableReferences(String.valueOf(varName) + "[" + i + "]", ((ArrayType)varType).getElementType(), prefix));
                return result;
            }
        }
        if (this.isRecord(varType)) {
            Iterator iter = ((RecordType)varType).getFieldNames().iterator();
            while (iter.hasNext()) {
                String fieldName = (String)iter.next();
                result.addAll(this.getInsensitiveVariableReferences(fieldName, ((RecordType)varType).getFieldType(fieldName), String.valueOf(prefix) + varName + "."));
            }
            return result;
        }
        result.add(String.valueOf(prefix) + varName);
        return result;
    }

    private boolean isRecord(Type varType) {
        return varType instanceof RecordType;
    }

    private boolean isArray(Type varType) {
        return varType instanceof ArrayType;
    }

    protected boolean isChan(Type varType) {
        return varType instanceof ChanType || varType instanceof RecType && ((RecType)varType).getBody() instanceof ChanType;
    }

    protected static boolean isPid(Type varType) {
        return varType instanceof NumericType && ((NumericType)varType).isPidType();
    }

    private static boolean isByte(Type varType) {
        return varType instanceof NumericType && ((NumericType)varType).isByteType();
    }
}

