/*
 * Decompiled with CFR 0.152.
 */
package symmreducer;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import promela.env.ChannelEntry;
import promela.env.ProctypeEntry;
import promela.env.VarEntry;
import promela.staticchanneldiagram.ProcessEntry;
import promela.staticchanneldiagram.StaticChannelDiagramExtractor;
import promela.types.ArrayType;
import promela.types.ChanType;
import promela.types.Type;
import symmreducer.PidIndexedArrayReference;
import symmreducer.SensitiveVariableReference;
import symmreducer.SymmetryApplier;
import symmreducer.TypeFlattener;

public class SymmetryApplierBasic
extends SymmetryApplier {
    public SymmetryApplierBasic(StaticChannelDiagramExtractor typeInfo, boolean segment) {
        super(typeInfo, segment);
        if (segment) {
            System.out.println("Segmented strategy not yet supported without transpositions");
            System.exit(1);
        }
    }

    public void applySymmetry(String fileName) {
        try {
            List lines = this.readInput(fileName);
            this.writeOutputWithSymmetryReduction(fileName, lines);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void writeOutputWithSymmetryReduction(String fileName, List lines) throws IOException {
        FileWriter fw = new FileWriter(fileName);
        int i = 0;
        while (i < lines.size()) {
            if (((String)lines.get(i)).indexOf("JAVA") != -1) {
                this.writeApplyPermToState(fw);
            } else {
                fw.write(String.valueOf((String)lines.get(i)) + "\n");
            }
            ++i;
        }
        fw.close();
    }

    private void writeApplyPermToState(FileWriter fw) throws IOException {
        this.permuteGlobalVariables(fw);
        this.permuteProctypeLocalVariables(fw);
        this.permuteChannelContents(fw);
        this.permuteProcesses(fw);
        this.permuteChannels(fw);
    }

    private void permuteGlobalVariables(FileWriter fw) throws IOException {
        Map globalVariables = this.typeInfo.getEnv().getTopVariableEntries();
        String referencePrefix = "s->";
        Iterator iter = globalVariables.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            VarEntry entry = (VarEntry)globalVariables.get(name);
            if (entry.isHidden() || entry instanceof ChannelEntry) continue;
            List sensitiveReferences = this.getSensitiveVariableReferences(name, entry.getType(), referencePrefix);
            int i = 0;
            while (i < sensitiveReferences.size()) {
                SensitiveVariableReference reference = (SensitiveVariableReference)sensitiveReferences.get(i);
                fw.write("   " + reference.getReference() + " = ");
                Assert.assertTrue(SymmetryApplierBasic.isPid(reference.getType()));
                fw.write("applyToPr(*alpha," + reference.getReference() + ");\n");
                ++i;
            }
            List sensitivelyIndexedArrays = this.getSensitivelyIndexedArrayReferences(name, entry.getType(), referencePrefix);
            int i2 = 0;
            while (i2 < sensitivelyIndexedArrays.size()) {
                PidIndexedArrayReference reference = (PidIndexedArrayReference)sensitivelyIndexedArrays.get(i2);
                Assert.assertTrue(SymmetryApplierBasic.isPid(((ArrayType)reference.getType()).getIndexType()));
                fw.write("   {\n");
                fw.write("       uchar swapper[" + reference.getArrayLength() + "];\n");
                fw.write("       for(j=0; j<" + reference.getArrayLength() + "; j++) {\n");
                fw.write("          swapper[applyToPr(*alpha,j)] = " + reference.getReference() + "[j];\n");
                fw.write("       }");
                fw.write("       memcpy(" + reference.getReference() + ",swapper," + reference.getArrayLength() + "*sizeof(uchar));\n");
                fw.write("   }\n");
                ++i2;
            }
        }
    }

    private void permuteProctypeLocalVariables(FileWriter fw) throws IOException {
        int j = 0;
        while (j < this.typeInfo.getProcessEntries().size()) {
            SensitiveVariableReference reference;
            String proctypeName = ((ProcessEntry)this.typeInfo.getProcessEntries().get(j)).getProctypeName();
            String referencePrefix = "((P" + this.typeInfo.getProctypeNames().indexOf(proctypeName) + " *)SEG(s," + (j + 1) + "))->";
            ProctypeEntry proctype = (ProctypeEntry)this.typeInfo.getEnvEntry(proctypeName);
            ArrayList referencesToPermute = new ArrayList();
            ArrayList sensitivelyIndexedArrays = new ArrayList();
            Iterator iter = proctype.getLocalVariableTypeInfo().keySet().iterator();
            while (iter.hasNext()) {
                String varName = (String)iter.next();
                referencesToPermute.addAll(this.getSensitiveVariableReferences(varName, (Type)proctype.getLocalVariableTypeInfo().get(varName), referencePrefix));
                sensitivelyIndexedArrays.addAll(this.getSensitivelyIndexedArrayReferences(varName, (Type)proctype.getLocalVariableTypeInfo().get(varName), referencePrefix));
            }
            iter = referencesToPermute.listIterator();
            while (iter.hasNext()) {
                reference = (SensitiveVariableReference)iter.next();
                fw.write("   " + reference.getReference() + " = ");
                Assert.assertTrue(SymmetryApplierBasic.isPid(reference.getType()) || this.isChan(reference.getType()));
                if (SymmetryApplierBasic.isPid(reference.getType())) {
                    fw.write("applyToPr");
                } else {
                    fw.write("applyToCh");
                }
                fw.write("(*alpha," + reference.getReference());
                if (this.isChan(reference.getType())) {
                    fw.write("-1)+1;\n");
                    continue;
                }
                fw.write(");\n");
            }
            iter = sensitivelyIndexedArrays.listIterator();
            while (iter.hasNext()) {
                reference = (PidIndexedArrayReference)iter.next();
                Assert.assertTrue(SymmetryApplierBasic.isPid(((ArrayType)reference.getType()).getIndexType()));
                fw.write("   {\n");
                fw.write("       uchar swapper[" + ((PidIndexedArrayReference)reference).getArrayLength() + "];\n");
                fw.write("       for(j=0; j<" + ((PidIndexedArrayReference)reference).getArrayLength() + "; j++) {\n");
                fw.write("          swapper[applyToPr(*alpha,j)] = " + reference.getReference() + "[j];\n");
                fw.write("       }");
                fw.write("       memcpy(" + reference.getReference() + ",swapper," + ((PidIndexedArrayReference)reference).getArrayLength() + "*sizeof(uchar));\n");
                fw.write("   }\n");
            }
            fw.write("\n");
            ++j;
        }
    }

    private void permuteChannelContents(FileWriter fw) throws IOException {
        int i = 0;
        while (i < this.typeInfo.getStaticChannelNames().size()) {
            ChanType type = (ChanType)((ChannelEntry)this.typeInfo.getEnvEntry((String)this.typeInfo.getStaticChannelNames().get(i))).getType();
            List flattenedFieldTypes = TypeFlattener.flatten(type.getMessageType());
            if (this.containsSensitiveType(flattenedFieldTypes)) {
                fw.write("   for(slot=0; slot<((Q" + (i + 1) + " *)QSEG(s," + i + "))->Qlen; slot++) {\n");
                int j = 0;
                while (j < flattenedFieldTypes.size()) {
                    if (SymmetryApplierBasic.isPid((Type)flattenedFieldTypes.get(j)) || this.isChan((Type)flattenedFieldTypes.get(j))) {
                        fw.write("      ((Q" + (i + 1) + " *)QSEG(s," + i + "))->contents[slot].fld" + j + " = ");
                        if (SymmetryApplierBasic.isPid((Type)flattenedFieldTypes.get(j))) {
                            fw.write("applyToPr");
                        } else {
                            Assert.assertTrue(this.isChan((Type)flattenedFieldTypes.get(j)));
                            fw.write("applyToCh");
                        }
                        fw.write("(*alpha,((Q" + (i + 1) + " *)QSEG(s," + i + "))->contents[slot].fld" + j);
                        if (this.isChan((Type)flattenedFieldTypes.get(j))) {
                            fw.write("-1)+1;\n");
                        } else {
                            Assert.assertTrue(SymmetryApplierBasic.isPid((Type)flattenedFieldTypes.get(j)));
                            fw.write(");\n");
                        }
                    }
                    ++j;
                }
                fw.write("   }\n");
            }
            ++i;
        }
    }

    private boolean containsSensitiveType(List flattenedFieldTypes) {
        int i = 0;
        while (i < flattenedFieldTypes.size()) {
            if (this.isChan((Type)flattenedFieldTypes.get(i)) || SymmetryApplierBasic.isPid((Type)flattenedFieldTypes.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void permuteProcesses(FileWriter fw) throws IOException {
        int j = 0;
        while (j < this.typeInfo.getProcessEntries().size()) {
            int proctypeIdentifier = this.typeInfo.getProctypeNames().indexOf(((ProcessEntry)this.typeInfo.getProcessEntries().get(j)).getProctypeName());
            fw.write("   j = applyToPr(*alpha," + (j + 1) + ");\n");
            fw.write("   memcpy(SEG(temp,j),SEG(s," + (j + 1) + "),sizeof(P" + proctypeIdentifier + "));\n");
            fw.write("   VAR(temp,j,_pid,P" + proctypeIdentifier + ")=VAR(s,j,_pid,P" + proctypeIdentifier + ");\n");
            fw.write("\n");
            ++j;
        }
    }

    private void permuteChannels(FileWriter fw) throws IOException {
        int j = 0;
        while (j < this.typeInfo.getStaticChannelNames().size()) {
            int chantypeIdentifier = j + 1;
            fw.write("   j = applyToCh(*alpha," + j + ");\n");
            fw.write("   memcpy(QSEG(temp,j),QSEG(s," + j + "),sizeof(Q" + chantypeIdentifier + "));\n");
            fw.write("   QVAR(temp,j,_t,Q" + chantypeIdentifier + ")=QVAR(s,j,_t,Q" + chantypeIdentifier + ");\n");
            fw.write("\n");
            ++j;
        }
    }

    private List readInput(String fileName) throws FileNotFoundException, IOException {
        String str;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        while ((str = br.readLine()) != null) {
            lines.add(str);
        }
        br.close();
        return lines;
    }
}

