/*
 * Decompiled with CFR 0.152.
 */
package symmreducer;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import junit.framework.Assert;
import promela.env.ChannelEntry;
import promela.env.ProctypeEntry;
import promela.env.VarEntry;
import promela.staticchanneldiagram.ProcessEntry;
import promela.staticchanneldiagram.StaticChannelDiagramExtractor;
import promela.types.ArrayType;
import promela.types.ChanType;
import promela.types.Type;
import symmreducer.PidIndexedArrayReference;
import symmreducer.SensitiveVariableReference;
import symmreducer.SymmetryApplier;
import symmreducer.TypeFlattener;

public class SymmetryApplierTranspositions
extends SymmetryApplier {
    public SymmetryApplierTranspositions(StaticChannelDiagramExtractor typeInfo, boolean segment) {
        super(typeInfo, segment);
    }

    public void applySymmetry(String fileName) {
        try {
            List lines = this.readInput(fileName);
            this.writeOutputWithSymmetryReduction(fileName, lines);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void writeOutputWithSymmetryReduction(String fileName, List lines) throws IOException {
        FileWriter fw = new FileWriter(fileName);
        boolean writtenApplyPrSwapToState = false;
        boolean writtenApplyChSwapToState = false;
        boolean writtenLt = false;
        int i = 0;
        while (i < lines.size()) {
            if (((String)lines.get(i)).indexOf("JAVA") != -1) {
                if (!writtenApplyPrSwapToState) {
                    this.writeApplyPrSwapToState(fw);
                    writtenApplyPrSwapToState = true;
                } else if (!writtenApplyChSwapToState) {
                    this.writeApplyChSwapToState(fw);
                    writtenApplyChSwapToState = true;
                } else if (!writtenLt) {
                    Assert.assertTrue(this.segment);
                    this.writeLt(fw);
                    writtenLt = true;
                } else {
                    Assert.assertTrue(this.segment);
                    this.writeConstructPartition(fw);
                }
            } else if (((String)lines.get(i)).indexOf("EQUAL METHODS") != -1) {
                Assert.assertTrue(this.segment);
                this.writeEqualProcesses(fw);
                this.writeEqualChannels(fw);
                this.writeGlobalVariablesForPartitionConstruction(fw);
            } else {
                fw.write(String.valueOf((String)lines.get(i)) + "\n");
            }
            ++i;
        }
        fw.close();
    }

    private void writeGlobalVariablesForPartitionConstruction(FileWriter fw) throws IOException {
        int i = 0;
        while (i < this.typeInfo.getProctypeNames().size()) {
            ArrayList<Integer> processIdsOfThisProctype = new ArrayList<Integer>();
            int j = 0;
            while (j < this.typeInfo.getProcessEntries().size()) {
                ProcessEntry process = (ProcessEntry)this.typeInfo.getProcessEntries().get(j);
                if (process.getProctypeName().equals(this.typeInfo.getProctypeNames().get(i))) {
                    processIdsOfThisProctype.add(new Integer(j + 1));
                }
                ++j;
            }
            fw.write("int no_P" + i + " = " + processIdsOfThisProctype.size() + ";\n");
            fw.write("int P" + i + "_procs[" + processIdsOfThisProctype.size() + "] = { ");
            j = 0;
            while (j < processIdsOfThisProctype.size()) {
                fw.write(processIdsOfThisProctype.get(j).toString());
                if (j < processIdsOfThisProctype.size() - 1) {
                    fw.write(", ");
                }
                ++j;
            }
            fw.write(" };\n\n");
            ++i;
        }
        i = 0;
        Iterator iter = this.typeInfo.getDistinctChannelSignatures().iterator();
        while (iter.hasNext()) {
            ChannelEntry channelSignature = (ChannelEntry)iter.next();
            ArrayList<Integer> channelsOfThisSignature = new ArrayList<Integer>();
            int j = 0;
            while (j < this.typeInfo.getStaticChannelNames().size()) {
                ChannelEntry channel = (ChannelEntry)this.typeInfo.getEnvEntry((String)this.typeInfo.getStaticChannelNames().get(j));
                if (channel.equal(channelSignature)) {
                    channelsOfThisSignature.add(new Integer(j));
                }
                ++j;
            }
            fw.write("int no_Chantype" + i + " = " + channelsOfThisSignature.size() + ";\n");
            fw.write("int chantype" + i + "_chans[" + channelsOfThisSignature.size() + "] = { ");
            j = 0;
            while (j < channelsOfThisSignature.size()) {
                fw.write(channelsOfThisSignature.get(j).toString());
                if (j < channelsOfThisSignature.size() - 1) {
                    fw.write(", ");
                }
                ++j;
            }
            fw.write(" };\n\n");
            ++i;
        }
    }

    private void writeConstructPartition(FileWriter fw) throws IOException {
        int i = 0;
        while (i < this.typeInfo.getProctypeNames().size()) {
            fw.write("  for(i=0; i<no_P" + i + "; i++) {\n");
            fw.write("    if(processClasses[P" + i + "_procs[i]]==-1) {\n");
            fw.write("      sprintf(temp,\"%d\",P" + i + "_procs[i]);\n");
            fw.write("      strcat(result,\"|\");\n");
            fw.write("      strcat(result,temp);\n\n");
            fw.write("      processClasses[P" + i + "_procs[i]]=++noProcessClasses;\n");
            fw.write("      int j;\n");
            fw.write("      for(j=i+1; j<no_P" + i + "; j++) {\n");
            fw.write("        if(equalProcesses(SEG(s,P" + i + "_procs[i]),SEG(s,P" + i + "_procs[j])," + i + ")) {\n");
            fw.write("          processClasses[P" + i + "_procs[j]] = noProcessClasses;\n");
            fw.write("          strcat(result,\",\");\n");
            fw.write("          sprintf(temp,\"%d\",P" + i + "_procs[j]);\n");
            fw.write("          strcat(result,temp);\n");
            fw.write("        }\n");
            fw.write("      }\n");
            fw.write("    }\n");
            fw.write("  }\n\n");
            ++i;
        }
        i = 0;
        while (i < this.typeInfo.getDistinctChannelSignatures().size()) {
            fw.write("  for(i=0; i<no_Chantype" + i + "; i++) {\n");
            fw.write("    if(channelClasses[chantype" + i + "_chans[i]]==-1) {\n");
            fw.write("      sprintf(temp,\"%d\",chantype" + i + "_chans[i]+NO_PROCS);\n");
            fw.write("      strcat(result,\"|\");\n");
            fw.write("      strcat(result,temp);\n\n");
            fw.write("      channelClasses[chantype" + i + "_chans[i]]=++noChannelClasses;\n");
            fw.write("      int j;\n");
            fw.write("      for(j=i+1; j<no_Chantype" + i + "; j++) {\n");
            fw.write("        if(equalChannels(QSEG(s,chantype" + i + "_chans[i]),QSEG(s,chantype" + i + "_chans[j]),chantype" + i + "_chans[i] + 1" + ")) {\n");
            fw.write("          channelClasses[chantype" + i + "_chans[j]] = noChannelClasses;\n");
            fw.write("          strcat(result,\",\");\n");
            fw.write("          sprintf(temp,\"%d\",chantype" + i + "_chans[j]+NO_PROCS);\n");
            fw.write("          strcat(result,temp);\n");
            fw.write("        }\n");
            fw.write("      }\n");
            fw.write("    }\n");
            fw.write("  }\n\n");
            ++i;
        }
    }

    private void writeEqualChannels(FileWriter fw) throws IOException {
        fw.write("int equalChannels(void* q1, void* q2, int qt) {");
        fw.write("   int slot;\n\n");
        fw.write("   switch(qt) {\n");
        int i = 1;
        while (i <= this.typeInfo.getStaticChannelNames().size()) {
            String q1Prefix = "((Q" + i + "*)q1)->";
            String q2Prefix = "((Q" + i + "*)q2)->";
            fw.write("      case " + i + ": if(" + q1Prefix + "Qlen!=" + q2Prefix + "Qlen) return 0;\n");
            ChanType type = (ChanType)((ChannelEntry)this.typeInfo.getEnvEntry((String)this.typeInfo.getStaticChannelNames().get(i - 1))).getType();
            List flattenedFieldTypes = TypeFlattener.flatten(type.getMessageType());
            if (this.containsInsensitiveType(flattenedFieldTypes)) {
                fw.write("        for(slot=0; slot<((Q" + i + "*)q1)->Qlen; slot++) {\n\n");
                int k = 0;
                while (k < flattenedFieldTypes.size()) {
                    if (!this.isChan((Type)flattenedFieldTypes.get(k)) && !SymmetryApplierTranspositions.isPid((Type)flattenedFieldTypes.get(k))) {
                        fw.write("          if(" + q1Prefix + "contents[slot].fld" + k + "!=" + q2Prefix + "contents[slot].fld" + k + ") return 0;\n");
                    }
                    ++k;
                }
                fw.write("        }\n");
            }
            fw.write("        return 1;\n");
            ++i;
        }
        fw.write("  }\n\n");
        fw.write("  printf(\"Error in channel comparison\\n\");\n\n");
        fw.write("  return 0;\n\n");
        fw.write("}\n\n");
    }

    private void writeEqualProcesses(FileWriter fw) throws IOException {
        fw.write("int equalProcesses(void* p1, void* p2, int pt) {");
        fw.write("   switch(pt) {\n");
        int i = 0;
        while (i < this.typeInfo.getProctypeNames().size()) {
            fw.write("      case " + i + ": return ((P" + i + "*)p1)->_p==((P" + i + "*)p2)->_p");
            ArrayList referencesToCompare = new ArrayList();
            ProctypeEntry proctype = (ProctypeEntry)this.typeInfo.getEnvEntry((String)this.typeInfo.getProctypeNames().get(i));
            Iterator iter = proctype.getLocalVariableTypeInfo().keySet().iterator();
            while (iter.hasNext()) {
                String varName = (String)iter.next();
                referencesToCompare.addAll(this.getInsensitiveVariableReferences(varName, (Type)proctype.getLocalVariableTypeInfo().get(varName), ""));
            }
            iter = referencesToCompare.listIterator();
            while (iter.hasNext()) {
                String reference = (String)iter.next();
                fw.write(" && ((P" + i + "*)p1)->" + reference + "==((P" + i + "*)p2)->" + reference);
            }
            fw.write(";\n");
            ++i;
        }
        fw.write("  }\n\n");
        fw.write("  printf(\"Error in process comparison\\n\");\n\n");
        fw.write("  return 0;\n\n");
        fw.write("}\n\n");
    }

    private void writeApplyChSwapToState(FileWriter fw) throws IOException {
        fw.write("   uchar tempCid;\n");
        fw.write("   int slot;\n");
        this.swapProctypeLocalChVariables(fw);
        this.swapChannelChContents(fw);
        this.swapChannels(fw);
    }

    private void writeApplyPrSwapToState(FileWriter fw) throws IOException {
        fw.write("   uchar tempPid;\n");
        fw.write("   int slot;\n");
        this.swapPrGlobal(fw);
        this.swapProctypeLocalPrVariables(fw);
        this.swapChannelPrContents(fw);
        this.swapProcesses(fw);
    }

    private void swapPrGlobal(FileWriter fw) throws IOException {
        Map globalVariables = this.typeInfo.getEnv().getTopVariableEntries();
        String referencePrefix = "s->";
        Iterator iter = globalVariables.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            VarEntry entry = (VarEntry)globalVariables.get(name);
            if (entry.isHidden() || entry instanceof ChannelEntry) continue;
            List sensitiveReferences = this.getSensitiveVariableReferences(name, entry.getType(), referencePrefix);
            int i = 0;
            while (i < sensitiveReferences.size()) {
                SensitiveVariableReference reference = (SensitiveVariableReference)sensitiveReferences.get(i);
                Assert.assertTrue(SymmetryApplierTranspositions.isPid(reference.getType()));
                fw.write("   if(" + reference.getReference() + "==a) {\n");
                fw.write("      " + reference.getReference() + " = b;\n");
                fw.write("   } else if(" + reference.getReference() + "==b) {\n");
                fw.write("      " + reference.getReference() + " = a;\n");
                fw.write("   }\n");
                ++i;
            }
            List sensitivelyIndexedArrays = this.getSensitivelyIndexedArrayReferences(name, entry.getType(), referencePrefix);
            int i2 = 0;
            while (i2 < sensitivelyIndexedArrays.size()) {
                PidIndexedArrayReference reference = (PidIndexedArrayReference)sensitivelyIndexedArrays.get(i2);
                Assert.assertTrue(SymmetryApplierTranspositions.isPid(((ArrayType)reference.getType()).getIndexType()));
                fw.write("   {\n");
                fw.write("       uchar temp;\n");
                fw.write("       temp = " + reference.getReference() + "[a];\n");
                fw.write("       " + reference.getReference() + "[a] = " + reference.getReference() + "[b];\n");
                fw.write("       " + reference.getReference() + "[b] = temp;\n");
                fw.write("   }\n");
                ++i2;
            }
        }
    }

    private void writeLt(FileWriter fw) throws IOException {
        fw.write("  int slot;\n\n");
        int j = 0;
        while (j < this.typeInfo.getProcessEntries().size()) {
            String proctypeName = ((ProcessEntry)this.typeInfo.getProcessEntries().get(j)).getProctypeName();
            String sPrefix = "((P" + this.typeInfo.getProctypeNames().indexOf(proctypeName) + " *)SEG(s," + (j + 1) + "))->";
            String tPrefix = "((P" + this.typeInfo.getProctypeNames().indexOf(proctypeName) + " *)SEG(t," + (j + 1) + "))->";
            ProctypeEntry proctype = (ProctypeEntry)this.typeInfo.getEnvEntry(proctypeName);
            fw.write("  if(" + sPrefix + "_p < " + tPrefix + "_p) return 1;\n");
            fw.write("  if(" + sPrefix + "_p > " + tPrefix + "_p) return 0;\n\n");
            ArrayList referencesToCompare = new ArrayList();
            Iterator iter = proctype.getLocalVariableTypeInfo().keySet().iterator();
            while (iter.hasNext()) {
                String varName = (String)iter.next();
                referencesToCompare.addAll(this.getInsensitiveVariableReferences(varName, (Type)proctype.getLocalVariableTypeInfo().get(varName), ""));
            }
            iter = referencesToCompare.listIterator();
            while (iter.hasNext()) {
                String reference = (String)iter.next();
                fw.write("  if(" + sPrefix + reference + " < " + tPrefix + reference + ") return 1;\n");
                fw.write("  if(" + sPrefix + reference + " > " + tPrefix + reference + ") return 0;\n\n");
            }
            ++j;
        }
        j = 0;
        while (j < this.typeInfo.getStaticChannelNames().size()) {
            ChanType type = (ChanType)((ChannelEntry)this.typeInfo.getEnvEntry((String)this.typeInfo.getStaticChannelNames().get(j))).getType();
            List flattenedFieldTypes = TypeFlattener.flatten(type.getMessageType());
            String sPrefix = "((Q" + (j + 1) + " *)QSEG(s," + j + "))->";
            String tPrefix = "((Q" + (j + 1) + " *)QSEG(t," + j + "))->";
            fw.write("  if(" + sPrefix + "Qlen < " + tPrefix + "Qlen) return 1;\n");
            fw.write("  if(" + sPrefix + "Qlen > " + tPrefix + "Qlen) return 0;\n\n");
            if (this.containsInsensitiveType(flattenedFieldTypes)) {
                fw.write("  for(slot=0; slot<((Q" + (j + 1) + " *)QSEG(s," + j + "))->Qlen; slot++) {\n\n");
                int k = 0;
                while (k < flattenedFieldTypes.size()) {
                    if (!this.isChan((Type)flattenedFieldTypes.get(k)) && !SymmetryApplierTranspositions.isPid((Type)flattenedFieldTypes.get(k))) {
                        fw.write("    if(" + sPrefix + "contents[slot].fld" + k + " < " + tPrefix + "contents[slot].fld" + k + ") return 1;\n");
                        fw.write("    if(" + sPrefix + "contents[slot].fld" + k + " > " + tPrefix + "contents[slot].fld" + k + ") return 0;\n\n");
                    }
                    ++k;
                }
                fw.write("   }\n\n");
            }
            ++j;
        }
    }

    private void swapProctypeLocalPrVariables(FileWriter fw) throws IOException {
        int j = 0;
        while (j < this.typeInfo.getProcessEntries().size()) {
            SensitiveVariableReference reference;
            String proctypeName = ((ProcessEntry)this.typeInfo.getProcessEntries().get(j)).getProctypeName();
            String referencePrefix = "((P" + this.typeInfo.getProctypeNames().indexOf(proctypeName) + " *)SEG(s," + (j + 1) + "))->";
            ProctypeEntry proctype = (ProctypeEntry)this.typeInfo.getEnvEntry(proctypeName);
            ArrayList referencesToPermute = new ArrayList();
            ArrayList sensitivelyIndexedArrays = new ArrayList();
            Iterator iter = proctype.getLocalVariableTypeInfo().keySet().iterator();
            while (iter.hasNext()) {
                String varName = (String)iter.next();
                referencesToPermute.addAll(this.getSensitiveVariableReferences(varName, (Type)proctype.getLocalVariableTypeInfo().get(varName), referencePrefix));
                sensitivelyIndexedArrays.addAll(this.getSensitivelyIndexedArrayReferences(varName, (Type)proctype.getLocalVariableTypeInfo().get(varName), referencePrefix));
            }
            iter = referencesToPermute.listIterator();
            while (iter.hasNext()) {
                reference = (SensitiveVariableReference)iter.next();
                Assert.assertTrue(SymmetryApplierTranspositions.isPid(reference.getType()) || this.isChan(reference.getType()));
                if (!SymmetryApplierTranspositions.isPid(reference.getType())) continue;
                fw.write("   if(" + reference.getReference() + "==a) {\n");
                fw.write("   " + reference.getReference() + " = b;\n");
                fw.write("   } else if(" + reference.getReference() + "==b) {\n");
                fw.write("   " + reference.getReference() + " = a;\n");
                fw.write("   }\n");
            }
            iter = sensitivelyIndexedArrays.listIterator();
            while (iter.hasNext()) {
                reference = (PidIndexedArrayReference)iter.next();
                Assert.assertTrue(SymmetryApplierTranspositions.isPid(((ArrayType)reference.getType()).getIndexType()));
                fw.write("   {\n");
                fw.write("       uchar temp;\n");
                fw.write("       temp = " + reference.getReference() + "[a];\n");
                fw.write("       " + reference.getReference() + "[a] = " + reference.getReference() + "[b];\n");
                fw.write("       " + reference.getReference() + "[b] = temp;\n");
                fw.write("   }\n");
            }
            fw.write("\n");
            ++j;
        }
    }

    private void swapChannelChContents(FileWriter fw) throws IOException {
        int i = 0;
        while (i < this.typeInfo.getStaticChannelNames().size()) {
            ChanType type = (ChanType)((ChannelEntry)this.typeInfo.getEnvEntry((String)this.typeInfo.getStaticChannelNames().get(i))).getType();
            List flattenedFieldTypes = TypeFlattener.flatten(type.getMessageType());
            if (this.containsChanType(flattenedFieldTypes)) {
                fw.write("   for(slot=0; slot<((Q" + (i + 1) + " *)QSEG(s," + i + "))->Qlen; slot++) {\n");
                int j = 0;
                while (j < flattenedFieldTypes.size()) {
                    if (this.isChan((Type)flattenedFieldTypes.get(j))) {
                        fw.write("      if(((Q" + (i + 1) + " *)QSEG(s," + i + "))->contents[slot].fld" + j + "==a+1) {\n");
                        fw.write("         ((Q" + (i + 1) + " *)QSEG(s," + i + "))->contents[slot].fld" + j + "=b+1;\n");
                        fw.write("      } else if(((Q" + (i + 1) + " *)QSEG(s," + i + "))->contents[slot].fld" + j + "==b+1) {\n");
                        fw.write("         ((Q" + (i + 1) + " *)QSEG(s," + i + "))->contents[slot].fld" + j + "=a+1;\n");
                        fw.write("      }\n");
                    }
                    ++j;
                }
                fw.write("   }\n");
            }
            ++i;
        }
    }

    private void swapChannelPrContents(FileWriter fw) throws IOException {
        int i = 0;
        while (i < this.typeInfo.getStaticChannelNames().size()) {
            ChanType type = (ChanType)((ChannelEntry)this.typeInfo.getEnvEntry((String)this.typeInfo.getStaticChannelNames().get(i))).getType();
            List flattenedFieldTypes = TypeFlattener.flatten(type.getMessageType());
            if (this.containsPidType(flattenedFieldTypes)) {
                fw.write("   for(slot=0; slot<((Q" + (i + 1) + " *)QSEG(s," + i + "))->Qlen; slot++) {\n");
                int j = 0;
                while (j < flattenedFieldTypes.size()) {
                    if (SymmetryApplierTranspositions.isPid((Type)flattenedFieldTypes.get(j))) {
                        fw.write("      if(((Q" + (i + 1) + " *)QSEG(s," + i + "))->contents[slot].fld" + j + "==a) {\n");
                        fw.write("         ((Q" + (i + 1) + " *)QSEG(s," + i + "))->contents[slot].fld" + j + "=b;\n");
                        fw.write("      } else if(((Q" + (i + 1) + " *)QSEG(s," + i + "))->contents[slot].fld" + j + "==b) {\n");
                        fw.write("         ((Q" + (i + 1) + " *)QSEG(s," + i + "))->contents[slot].fld" + j + "=a;\n");
                        fw.write("      }\n");
                    }
                    ++j;
                }
                fw.write("   }\n");
            }
            ++i;
        }
    }

    private void swapProctypeLocalChVariables(FileWriter fw) throws IOException {
        int j = 0;
        while (j < this.typeInfo.getProcessEntries().size()) {
            String proctypeName = ((ProcessEntry)this.typeInfo.getProcessEntries().get(j)).getProctypeName();
            String referencePrefix = "((P" + this.typeInfo.getProctypeNames().indexOf(proctypeName) + " *)SEG(s," + (j + 1) + "))->";
            ProctypeEntry proctype = (ProctypeEntry)this.typeInfo.getEnvEntry(proctypeName);
            ArrayList referencesToPermute = new ArrayList();
            Iterator iter1 = proctype.getLocalVariableTypeInfo().keySet().iterator();
            while (iter1.hasNext()) {
                String varName = (String)iter1.next();
                referencesToPermute.addAll(this.getSensitiveVariableReferences(varName, (Type)proctype.getLocalVariableTypeInfo().get(varName), referencePrefix));
            }
            ListIterator iter = referencesToPermute.listIterator();
            while (iter.hasNext()) {
                SensitiveVariableReference reference = (SensitiveVariableReference)iter.next();
                Assert.assertTrue(SymmetryApplierTranspositions.isPid(reference.getType()) || this.isChan(reference.getType()));
                if (!this.isChan(reference.getType())) continue;
                fw.write("   if(" + reference.getReference() + "==a+1) {\n");
                fw.write("      " + reference.getReference() + " = b+1;\n");
                fw.write("   } else if(" + reference.getReference() + "==b+1) {\n");
                fw.write("      " + reference.getReference() + " = a+1;\n");
                fw.write("   }\n");
            }
            fw.write("\n");
            ++j;
        }
    }

    private boolean containsPidType(List flattenedFieldTypes) {
        int i = 0;
        while (i < flattenedFieldTypes.size()) {
            if (SymmetryApplierTranspositions.isPid((Type)flattenedFieldTypes.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsChanType(List flattenedFieldTypes) {
        int i = 0;
        while (i < flattenedFieldTypes.size()) {
            if (this.isChan((Type)flattenedFieldTypes.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsInsensitiveType(List flattenedFieldTypes) {
        int i = 0;
        while (i < flattenedFieldTypes.size()) {
            if (!SymmetryApplierTranspositions.isPid((Type)flattenedFieldTypes.get(i)) && !this.isChan((Type)flattenedFieldTypes.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void swapProcesses(FileWriter fw) throws IOException {
        int j = 0;
        while (j < this.typeInfo.getProcessEntries().size()) {
            int proctypeIdentifier = this.typeInfo.getProctypeNames().indexOf(((ProcessEntry)this.typeInfo.getProcessEntries().get(j)).getProctypeName());
            fw.write("   if(a==" + (j + 1) + ") {\n");
            fw.write("      P" + proctypeIdentifier + " temp;\n");
            fw.write("      memcpy(&temp,SEG(s,a),sizeof(P" + proctypeIdentifier + "));\n");
            fw.write("      memcpy(SEG(s,a),SEG(s,b),sizeof(P" + proctypeIdentifier + "));\n");
            fw.write("      memcpy(SEG(s,b),&temp,sizeof(P" + proctypeIdentifier + "));\n");
            fw.write("      tempPid = VAR(s,a,_pid,P" + proctypeIdentifier + ");\n");
            fw.write("      VAR(s,a,_pid,P" + proctypeIdentifier + ") = VAR(s,b,_pid,P" + proctypeIdentifier + ");\n");
            fw.write("      VAR(s,b,_pid,P" + proctypeIdentifier + ") = tempPid;\n");
            fw.write("      return;\n");
            fw.write("   }\n\n");
            ++j;
        }
    }

    private void swapChannels(FileWriter fw) throws IOException {
        int j = 0;
        while (j < this.typeInfo.getStaticChannelNames().size()) {
            int chantypeIdentifier = j + 1;
            fw.write("   if(a==" + j + ") {\n");
            fw.write("      Q" + chantypeIdentifier + " temp;\n");
            fw.write("      memcpy(&temp,QSEG(s,a),sizeof(Q" + chantypeIdentifier + "));\n");
            fw.write("      memcpy(QSEG(s,a),QSEG(s,b),sizeof(Q" + chantypeIdentifier + "));\n");
            fw.write("      memcpy(QSEG(s,b),&temp,sizeof(Q" + chantypeIdentifier + "));\n");
            fw.write("      tempCid = QVAR(s,a,_t,Q" + chantypeIdentifier + ");\n");
            fw.write("      QVAR(s,a,_t,Q" + chantypeIdentifier + ") = QVAR(s,b,_t,Q" + chantypeIdentifier + ");\n");
            fw.write("      QVAR(s,b,_t,Q" + chantypeIdentifier + ") = tempCid;\n");
            fw.write("   };\n");
            fw.write("\n");
            ++j;
        }
    }

    private List readInput(String fileName) throws FileNotFoundException, IOException {
        String str;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        while ((str = br.readLine()) != null) {
            lines.add(str);
        }
        br.close();
        return lines;
    }
}

