/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class Config {
    private static String saucy = null;
    private static String gap = null;
    private static String tempFiles = null;
    private static String common = null;

    public static boolean isOSWindows() {
        return System.getProperty("os.name").length() >= "Windows".length() && System.getProperty("os.name").substring(0, 7).equals("Windows");
    }

    public static void readConfigFile(String filename) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(filename));
            int n = 0;
            while ((line = br.readLine()) != null) {
                Config.processConfigurationLine(line, ++n);
            }
            if (gap == null) {
                System.out.println("No configuration specified for GAP.");
            }
            if (saucy == null) {
                System.out.println("No configuration specified for saucy.");
            }
            if (common == null) {
                System.out.println("No common directory specified.");
            }
            if (tempFiles == null) {
                System.out.println("No temporary directory specified.");
            }
            if (gap == null || saucy == null || common == null || tempFiles == null) {
                System.exit(1);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening configuration file.");
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("Error reading configuration file.");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void processConfigurationLine(String line, int n) {
        StringTokenizer strtok = new StringTokenizer(line, "=");
        if (strtok.countTokens() != 2) {
            System.out.println("Line " + n + " of configuration file badly formed.");
        } else {
            String name = strtok.nextToken();
            String value = strtok.nextToken();
            if (name.equals("gap") && gap == null) {
                gap = value;
            } else if (name.equals("saucy") && saucy == null) {
                saucy = value;
            } else if (name.equals("tempfiles") && tempFiles == null) {
                tempFiles = value;
            } else if (name.equals("common") && common == null) {
                common = value;
            } else {
                System.out.println("Line " + n + " of configuration file redefines a configuration item, or refers to an item which does not exist.");
            }
        }
    }

    public static String saucy() {
        return saucy;
    }

    public static String gap() {
        return gap;
    }

    public static String tempFiles() {
        return tempFiles;
    }

    public static String common() {
        return common;
    }
}

