Moved := function(alpha)

  local result, i, orbits;

  orbits := Orbits(Group(alpha));
  result := [];
  for i in [1..Size(orbits)] do
    result := Union(result,orbits[i]);
  od;

  return result;

end;;


FindRep := function(i,rep)

  local changed, result;

  changed := true;
  result := i;

  while changed do
    changed := false;

    if not(result = rep[result]) then
      result := rep[result];
      changed := true;
    fi;

  od;

  return result;
end;;


DisjointFactors := function(G)

  local gens, i, j, result, R, E, Classes;


  gens := GeneratorsOfGroup(G);

  R := [];

  for i in [1..Size(gens)] do
    Add(R,[]);
  od;

  for i in [1..Size(gens)-1] do

    for j in [i+1..Size(gens)] do

	if not(Intersection(Moved(gens[i]),Moved(gens[j])) = []) then
		Add(R[i],j);
        fi;

    od;

  od;

  E := EquivalenceRelationByRelation(BinaryRelationOnPoints(R));

  Classes := EquivalenceClasses(E);

  result := [];

  for i in [1..Size(Classes)] do
    Add(result,[]);
    for j in [1..Size(gens)] do
      if EquivalenceClassOfElement(E,j)=Classes[i] then
         Add(result[i],gens[j]);
      fi;
    od;
  od;

  return result;

end;;



ClassifyGroup := function(G,n)

  

  local result, symmetricOrder, theta, i, j, finished, alpha,
        H, K, gens, gensIndex, blockPermuter, B, O,O1, O2, o, S, N, factorGenerators, G1;

  result := "";


  # SYMMETRIC GROUP
  if Size(G)>2 then
    symmetricOrder := n;
    finished := false;
    while (symmetricOrder > 1) and (not finished) do
      if (Factorial(symmetricOrder) < Size(G)) then
        finished := true;
      fi;
 
      if (Factorial(symmetricOrder) = Size(G)) then
        theta := IsomorphismGroups(SymmetricGroup(symmetricOrder),G);
        if(not(theta=fail)) then
  	  result := Concatenation(result,"<minimise>\n",String(symmetricOrder*(symmetricOrder-1)/2),"\n");
	  # Make a list of images of swaps & output this list
          for i in [1..symmetricOrder-1] do
            for j in [i+1..symmetricOrder] do
              result := Concatenation(result,PermToString((i,j)^theta),"\n");
            od;
          od;

          return result;
        else
          finished := true;
        fi;
      fi;
      symmetricOrder := symmetricOrder - 1;
    od;
  fi;

  # Disjoint Products
  G1 := G; # To avoid feature interaction between wreath and disjoint products
   factorGenerators := DisjointFactors(G1);

   if Size(factorGenerators)>1 then

     for i in [1..Size(factorGenerators)] do
       result := Concatenation(result,ClassifyGroup(Group(factorGenerators[i]),n));
     od;

     return result;
  fi;

  # Old Method of Computing Disjoint products
  #N := NormalSubgroups(G);
  #for i in [2..Size(N)-2] do
  #  for j in [i+1..Size(N)-1] do
  #    if(Size(N[i])*Size(N[j])=Size(G)) then
  #      O1 := []; O2 := [];
  #      for o in Orbits(N[i]) do
  #        O1 := Union(O1,o);
  #      od;
  #      for o in Orbits(N[j]) do
  #        O2 := Union(O2,o);
  #      od;
  #      if IsEmpty(Intersection(O1,O2)) then
#	  Print("Found direct product!\n");
#	  Print("H = ",N[i],"\nK = ",N[j],"\n");
#          result := Concatenation(result,ClassifyGroup(N[i],n));
#          result := Concatenation(result,ClassifyGroup(N[j],n));
#          return result;
#        fi;
#      fi;
#    od;
#  od;


#Print(Orbits(G));


  # Wreath products
  O := Orbits(G);                                # Find all orbits of G
  for o in O do                                  # for each orbit
#    Print("Considering orbit ",o,"\n");
    B := MaximalBlocks(G,o);                     # find a maximal block system (this is the line I'm not sure about)
    if Size(B)>1 then
 #     Print("Found block system: ",B,"\n");
      H := G;
      for i in [2..Size(B)] do
        for j in [1..Size(B[i])] do
          H := Stabilizer(H,B[i][j]);
        od;
      od;

  #    Print("Considering ",H," as a base group\n");

      if not(H=Group(())) then
        K := G;
        S := [];                                    # S is the set {b_11,b_21,...,b_k1} etc.
        for i in [1..Size(B[1])] do
          for j in [1..Size(B)] do
            S[j]:=B[j][i];
          od;

	#  Print("About to stabilise the set ",S,"\n");
  	  #Print(Stabilizer(K,S,OnSets),"\n");
          K := Stabilizer(K,S,OnSets);

         # Print("The group K is now ",K,"\n");

        od;

        if (not(K=Group(()))) and G = Group(Concatenation(GeneratorsOfGroup(H),GeneratorsOfGroup(K))) then
        
          # The group is a wreath product with base group H and acting group K.

  	  result := Concatenation(result,ClassifyGroup(H,n)); # classify first basic group

	

##	  for i in [2..Size(B)] do

##            blockPermuter := RepresentativeAction(K,B[1][1],B[i][1]);
##            gens := []; gensIndex := 1;
##            for alpha in GeneratorsOfGroup(H) do
##              gens[gensIndex] := alpha^blockPermuter;
##              gensIndex := gensIndex + 1;
##            od;
            # gens is now a generating set for a new copy of the base group
	  #  Print("Base group: ",gens," has size ",Size(Group(gens)),"\n");
##            result := Concatenation(result,ClassifyGroup(Group(gens),n));
##          od;

          # finally we can classify the acting group.

          result := Concatenation(result,ClassifyGroup(K,n));

	  return result;
        fi;

      fi;
    fi;
  od;

  if(IsCyclic(G)) then
    if(useSimsMethod) then
      return EnumerateGroupByStabilizerChainCosets(G);
    else
      return EnumerateGroup(G);
    fi;
  fi;

  if (((Size(G) mod 2) = 0) and (Size(G)<=(2*n))) then
    if(not(IsomorphismGroups(G,DihedralGroup(Size(G)))=fail)) then
      if(useSimsMethod) then
        return EnumerateGroupByStabilizerChainCosets(G);
      else
        return EnumerateGroup(G);
      fi;

    fi;
  fi;
  
  # Group is unclassifiable, so use local search
  result := Concatenation(result,"<localsearch>\n",String(Size(GeneratorsOfGroup(G))),"\n");
  for alpha in GeneratorsOfGroup(G) do
    result := Concatenation(result,PermToString(alpha),"\n");
  od;
  return result;

end;;

ClassifyBest := function(G,fname,n)

  local newGens, alpha;

  # Ensure that identity is not included as a generator
  newGens := [];
  for alpha in GeneratorsOfGroup(G) do
    if not((alpha=()) or (alpha in newGens)) then
      Add(newGens,alpha);
    fi;
  od;

  PrintTo(fname,ClassifyGroup(Group(newGens),n));

end;;
