#ifndef VBOCREATOR_H_
#define VBOCREATOR_H_

#include "defs.h"
#include "Singleton.h"
#include "UGridTetrahedrizer.h"

#include <vtkPointData.h>

#include <vector>


class VBOCreator : public Singleton<VBOCreator>{

  friend class Singleton<VBOCreator>;

public:
  ~VBOCreator();
  void convertUGridToVBO();
  
  void initVBOTetras(unsigned int numTetras);

  void initPBOSubPixels(unsigned int windowWidth, unsigned int windowHeight);
  void initPBOSubPixelsDepth(unsigned int windowWidth, unsigned int windowHeight);
  void initPBOPixels(unsigned int windowWidth, unsigned int windowHeight);
  void initTexture(unsigned int windowWidth, unsigned int windowHeight);

  GLuint getVBOTetra(){return m_vboTetraID;};
  GLuint getPBOSubPixels(){return m_pboSubPixelID;};
  GLuint getPBOSubPixelsDepth(){return m_pboSubPixelDepthID;};
  GLuint getPBOPixels(){return m_pboPixelID;};
  GLuint getScreenMapTextureID(){return m_screenMapTextureID;};

  unsigned int getNumTetras(){return m_numTetras;};
  tetraFloat* getTetras(){return m_tetras;};
  float* getTetraVolumes(){return m_tetraVolumes;};

protected:
  VBOCreator();
  VBOCreator(VBOCreator& dontcopy){};
  
  tetraFloat cellToTetra(unsigned int cellID, vtkUnstructuredGrid* grid);
  float cellVolume(tetraFloat tetra);

  unsigned int m_numTetras;
  GLuint m_vboTetraID;
  GLuint m_pboSubPixelID;
  GLuint m_pboSubPixelDepthID;
  GLuint m_pboPixelID;
  GLuint m_screenMapTextureID;
  char* m_className;
  tetraFloat* m_tetras;
  float* m_tetraVolumes;

}; 

#endif