/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/


#include "aggregation/aggregation.cuh"
#include "tools/common.cuh"
#include "communicator/dparams.cuh"
#include "communicator/hparams.h"
#include "stdio.h"

#ifndef USE_CUDA_HEAP
#include "memory/UseScatterAlloc.cuh"
#endif 

namespace Softshell
{
  void initLocalAggregation(HParams* hparams);


  __device__ Aggregation* d_aggregation = 0;
  __device__ uint DefaultWorkItemTimeout = 100000;

  __global__ void d_initAggregation(uint tmin, uint tmax)
  {
    //printf("creating aggregation with %d %d\n",tmin,tmax);
    d_aggregation = new Aggregation(tmin, tmax);
  }
  

  void initAggregation(HParams* hparams)
  {
    uint tmin = hparams->addParam<uint>(P_AggregationMinNumThreads, 128);
    uint tmax = hparams->addParam<uint>(P_AggregationMaxNumThreads, 1024);
    uint timeout = hparams->addParam<uint>(P_DefaultWorkItemTimeout, 10000);

    d_initAggregation<<<1,1>>>(tmin, tmax);
    CUDA_CHECKED_CALL(cudaDeviceSynchronize());
    CUDA_CHECKED_CALL(cudaMemcpyToSymbol(DefaultWorkItemTimeout, &timeout, sizeof(uint)));
    initLocalAggregation( hparams);
  }

}