/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/


#ifndef SOFTSHELL_AGGREGATION_PAYLOADEDWORKPACKAGE_H_INCLUDED
#define SOFTSHELL_AGGREGATION_PAYLOADEDWORKPACKAGE_H_INCLUDED

#include "api/workitem.h"
#include "api/procedure.h"
#include "tools/types.h"

namespace Softshell
{
  struct PayloadDetails
  {
    uint execpoint;
    uint info2;
    uint info3;
    uint info4;
    __device__ PayloadDetails(uint _execpoint) : execpoint(_execpoint), info2(0), info3(0), info4(0) { }
  };
  template<class TWorkItem, uint TCapacity = 256>
  class PayloadedWorkpackageDetail : public CombWorkpackageParams<TWorkItem, PayloadDetails>
  {
  public:
    static const uint Capacity = TCapacity;
  protected:
    TWorkItem data[TCapacity];
  public:
    __device__ PayloadedWorkpackageDetail(DEvent const& event, const PayloadDetails& params = PayloadDetails(1), clock64_t timeout = getTimeCycles() + DefaultWorkItemTimeout) :
        CombWorkpackageParams<TWorkItem, PayloadDetails>(event, TCapacity, data, params, timeout,0,2) { }
    __device__ uint getExecPoint() const volatile
    {
      return CombWorkpackageParams<TWorkItem, PayloadDetails>::getParams(0)->execpoint;
    }
  };


//THIRDTIER_BEGIN
#define THIRDTIER_BEGIN \
  struct __Payload \
  { \
  PAYLOAD_BEGIN(__Payload)

#define THIRDTIER_EXT_BEGIN(NAME) \
  struct NAME \
  { \
  PAYLOAD_BEGIN(NAME)

//PAYLOAD_BEGIN
#define PAYLOAD_BEGIN(NAME) \
    __device__ uint __initialThreadId() const  \
    {  \
      return ___iTid;  \
    };  \
    Workpackage* ___wp;  \
    uint  ___iTid;  \
    __device__ NAME()  \
    {  \
    }  \
    __device__ NAME(Workpackage* wp) : ___wp(wp), ___iTid(__threadId())  \
    {  \
    }


#define THIRDTIER_EXECUTE \
__device__ void __execute(Softshell::Workpackage* workpackage, int execpoint, DeviceEntryProcedureFunc proc)  \
{  \
  volatile uint* ___active = (volatile uint*)(__sharedAlloc(sizeof(uint)));  \
  /*if(___active == 0) { printf("outch!\n"); ::trap(); }; */\
  ___active[0] = __numThreads();  \
  __sync();  \
  switch(execpoint)  \
  { \
  case -1: \
  {
//

//SCHEDULEDWHILE
#define SCHEDULEDWHILE_EXT(NAME, EXPR, ACTIVEIN, ACTIVERATIO) \
  _SCHEDULEDWHILE(NAME, EXPR, ACTIVEIN, ACTIVERATIO, __COUNTER__ +2 )
#define SCHEDULEDWHILE(EXPR, ACTIVEIN, ACTIVERATIO) \
  _SCHEDULEDWHILE(__Payload, EXPR, ACTIVEIN, ACTIVERATIO, __COUNTER__ +2 )
#define _SCHEDULEDWHILE(NAME, EXPR, ACTIVEIN, ACTIVERATIO, POINT) \
} \
case POINT: \
{ \
  const uint ___entryPoint = POINT; \
  uint ___threshold; \
  if(__numThreads() > 32) \
    ___threshold = __numThreads()*ACTIVERATIO; \
  else \
    ___threshold = 0; \
  int ___counter = -1; \
  while(true) \
    if(++___counter == ACTIVEIN) \
    { \
      if(!(EXPR)) \
      { \
        _SCHEDLEDDROPOUT \
        break;  \
      }  \
      else if(*___active < ___threshold)  \
      {  \
        PayloadDetails pd(___entryPoint);  \
        __threadfence_block(); \
        LocalAggregation::addWorkItem<NAME>(workpackage->getEvent(), proc, *((NAME*)this), sizeof(PayloadDetails), (uint*)&pd, 0, ___entryPoint, DefaultWorkItemTimeout);  \
        return;  \
      }  \
      ___counter = -1;  \
    }  \
    else
//

//SCHEDULEDRETURN
#define SCHEDULEDRETURN \
  { \
  _SCHEDLEDDROPOUT \
  return; \
  }
//
//SCHEDULREDBREAK;
#define SCHEDULREDBREAK \
  { \
  _SCHEDLEDDROPOUT \
  break; \
  }
//
#define _SCHEDLEDDROPOUT \
uint m = __ballot(1);  \
uint c = __popc(m);  \
if((lanemask_lt() & m) == 0)  \
  uint old = atomicSub((uint*)___active,c);
//

//THIRDTIER_EXT_END
#define THIRDTIER_EXT_END \
      } \
    } \
  } \
}; 

//THIRDTIER_END
#define THIRDTIER_END \
      } \
    } \
  } \
}; \
THIRDTIER_CALLER

//THIRDTIER_CALLER
#define THIRDTIER_CALLER \
  THIRDTIER_EXT_CALLER(__Payload)

#define THIRDTIER_EXT_CALLER(NAME) \
if(workpackage->isPayloaded()) \
{ \
  volatile PayloadedWorkpackageDetail<NAME>* pwp = (volatile PayloadedWorkpackageDetail<NAME>*)(workpackage); \
  volatile PayloadDetails* pd = pwp->getParams(__threadId()); \
   \
  int execpoint = pwp->getExecPoint();  \
  __sync(); \
  NAME * pl =  (NAME *) pwp->getWorkItem(__threadId()); \
  NAME cpl = * pl; \
  __sync(); \
  if(__threadId() == 0)  \
    pwp->destroy(); \
  cpl.__execute(cpl.___wp, execpoint, (DeviceEntryProcedureFunc)(execute)); \
}  \
else   \
{  \
  NAME pl(workpackage);  \
  pl.__execute(workpackage, -1,(DeviceEntryProcedureFunc)(execute));  \
}
//

}


#endif
