/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#ifndef SOFTSHELL_COMMUNICATOR_DCOMMUNICATOR_CUH_INCLUDED
#define SOFTSHELL_COMMUNICATOR_DCOMMUNICATOR_CUH_INCLUDED

#include "tools/types.h"
#include "communicator/communicatordata.h"
#include "stdlib/vector.cuh"

namespace Softshell
{
  //TODO: this is a hack to get around the CUDA 5.0 vtable linker error,
  // make receiverMessage virtual after fix!
  class DMessageReceiver
  {
  public:
    inline __device__ void receiveMessage(MessageHeader& h, volatile uint* data, uint linid, uint threads)
    {
    }
  };
  class DCommunicator : public DMessageReceiver
  {
    static const uint ReportReadThreshold = 64;
    typedef void (*ReceiverFunc)(void*receiver, MessageHeader& h, volatile uint* data, uint linid, uint threads);

    MessageBuffer *inbuffer, *outbuffer;
    uint inbuffer_lastwritten;
    uint already_read;
    struct ReceiverEntry
    {
      void* receiver;
      ReceiverFunc func;
      __device__ ReceiverEntry()
      { }
      __device__ ReceiverEntry(void* _receiver, ReceiverFunc _func) : receiver(_receiver), func(_func)
      { }
    };
    //std_gpu::vector< ReceiverEntry > receivers;
    static const uint ReceiverEntries = 128;
    ReceiverEntry receivers[ReceiverEntries];
  public:
    __device__ inline DCommunicator(MessageBuffer* in, MessageBuffer* out);
    template<class T>
    __device__ inline bool registerMessageReceiver(T* receiver, uint id);
    __device__ inline bool send(uint id, uint size, uint* message);

    __device__ inline int dispatch(uint linid, uint threads);




    __device__ inline void receiveMessage(MessageHeader& h, volatile uint* data, uint linid, uint threads);
  };

  extern __device__ DCommunicator* d_communicator;
}

#include "communicator/dcommunicator.ipp"
#endif //SOFTSHELL_COMMUNICATOR_DCOMMUNICATOR_INCLUDED
