/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/


#include "communicator/dparams.cuh"
#include "communicator/params.h"
#include "tools/utils.h"

#include "queue/queue.cuh"
#include "aggregation/aggregation.cuh"


namespace Softshell
{
  extern  __device__ float maxExecTime;
  extern __device__ uint sleepTime;

  class HParams;
  __device__ DParams* d_params;

#define ParamDataAccess(TYPE) \
  ((reinterpret_cast<volatile Param<TYPE>*>(data))->data)

  __device__ void DParams::receiveMessage(MessageHeader& h, volatile uint* data, uint linid, uint threads)
  {
    if(h.id == H2D_Param)
    {
      volatile ParamBase* paramBase = reinterpret_cast<volatile ParamBase*>(data);
      switch(paramBase->paramId)
      {
      case P_SortingBorder:
        d_queue.setSortingBorder(ParamDataAccess(uint));
        break;
      case P_SleepTime:
        sleepTime = ParamDataAccess(uint);
        break;
      case P_AggregationMinNumThreads:
         d_aggregation->minAggregationSize = ParamDataAccess(uint);
        break;
      case P_AggregationMaxNumThreads:
         d_aggregation->maxAggregationSize = ParamDataAccess(uint);
        break;
      case P_DefaultWorkItemTimeout:
        DefaultWorkItemTimeout = ParamDataAccess(uint);
        break;
      }
    }
  }


  __global__ void d_initDParams()
  {
    d_params = new DParams();
  }
  void initDParams(HParams* params)
  {
    d_initDParams<<<1,1>>>();
    CUDA_CHECKED_CALL(cudaDeviceSynchronize());
  }
}


