/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/


#ifndef SOFTSHELL_COMMUNICATOR_HMESSAGERECEIVER_H_INCLUDED
#define SOFTSHELL_COMMUNICATOR_HMESSAGERECEIVER_H_INCLUDED

#include "communicator/communicatordata.h"
#include "tools/thread.h"
#include "tools/utils.h"
#include <vector>


namespace Softshell
{
  class HMessageReceiver
  {
  public:
    virtual uint numReceivingMessages() const = 0;
    virtual uint receivingMessageId(uint i) const = 0;
    virtual void receiveMessage(MessageHeader& h, uint* data) = 0;
  };

  class HCommunicator : public HMessageReceiver, private Thread
  {
    static const uint WAIT_MS = 2;

    Signal signal;
    volatile bool run;
    volatile bool sleep;

    MessageBuffer *h_HostToDeviceBuffer, *h_DeviceToHostBuffer;
    MessageBuffer *d_HostToDeviceBuffer, *d_DeviceToHostBuffer;

    Mutex sendbufferMutex;
    std::vector<HMessageReceiver*> receivers;
    uint inbuffer_lastwritten;
    uint already_read;

    int execute();
    void init();
    void cleanup();
    uint processMessages();


  public:
    HCommunicator();
    ~HCommunicator();
    void registerMessageReceiver(HMessageReceiver* receiver);
    bool send(uint messageId, uint size, uint* message);
    void start();
    void pause();
    void shutdown();
    void join();
     //Message Receiver
    uint numReceivingMessages() const;
    uint receivingMessageId(uint i) const;
    void receiveMessage(MessageHeader& h, uint* data);
  };

}
#endif //SOFTSHELL_COMMUNICATOR_HCOMMUNICATOR_INCLUDED
