/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/


#ifndef SOFTSHELL_COMMUNICATOR_MESSAGEIDS_H_INCLUDED
#define SOFTSHELL_COMMUNICATOR_MESSAGEIDS_H_INCLUDED

#include "tools/utils.h"

namespace Softshell
{
  enum DeviceToHostMessages
  {
    D2H_ERROR = 0,
    D2H_ElementsReadFromBuffer,
    D2H_EventLaunchDone,
    D2H_QueueEmpty,
    D2H_Param,
    //
    D2H_PING,
    D2H_PONG,
    D2H_DEBUG
  };
  enum HostToDeviceMessages
  {
    H2D_ERROR = 0,
    H2D_Dummy,
    H2D_ElementsReadFromBuffer,
    H2D_Terminate,
    H2D_CancelEvent,
    H2D_ActivateQueue,
    H2D_DeactivateQueue,
    H2D_FireEvent,
    H2D_EventPriority,
    H2D_EventPeriodicity,
    H2D_EventDeadline,
    H2D_TimePulse,
    H2D_Param,
    //
    H2D_PING,
    H2D_PONG
  };


  #define EnumToCharCase(ENUM_VALUE) \
    case ENUM_VALUE: \
    return #ENUM_VALUE;

  __host__ __device__ static const char* getH2DMessageName(unsigned int id)
  {
    switch(id)
    {
      EnumToCharCase(H2D_ERROR)
      EnumToCharCase(H2D_Dummy)
      EnumToCharCase(H2D_ElementsReadFromBuffer)
      EnumToCharCase(H2D_Terminate)
      EnumToCharCase(H2D_CancelEvent)
      EnumToCharCase(H2D_ActivateQueue)
      EnumToCharCase(H2D_DeactivateQueue)
      EnumToCharCase(H2D_FireEvent)
      EnumToCharCase(H2D_EventPriority)
      EnumToCharCase(H2D_EventPeriodicity)
      EnumToCharCase(H2D_EventDeadline)
      EnumToCharCase(H2D_TimePulse)
      EnumToCharCase(H2D_Param)
      EnumToCharCase(H2D_PING)
      EnumToCharCase(H2D_PONG)
    default:
      return "[unknown H2D message id]";
    }
  }

  __host__ __device__ static const char* getD2HMessageName(unsigned int id)
  {
    switch(id)
    {
      EnumToCharCase(D2H_ERROR)
      EnumToCharCase(D2H_ElementsReadFromBuffer)
      EnumToCharCase(D2H_EventLaunchDone)
      EnumToCharCase(D2H_QueueEmpty)
      EnumToCharCase(D2H_Param)
      EnumToCharCase(D2H_PING)
      EnumToCharCase(D2H_PONG)
      EnumToCharCase(D2H_DEBUG)
    default:
      return "[unknown D2H message id]";
    }
  }
  #undef EnumToCharCase
}

#endif //SOFTSHELL_COMMUNICATOR_MESSAGEIDS_INCLUDED
