/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#ifndef SOFTSHELL_COMMUNICATOR_PARAMS_H_INCLUDED
#define SOFTSHELL_COMMUNICATOR_PARAMS_H_INCLUDED

#include <map>
#include <string>


namespace Softshell
{
  enum ParamId
  {
    P_Nothing,
    P_SortingBorder,
    P_SleepTime,
    P_AggregationMinNumThreads,
    P_AggregationMaxNumThreads,
    P_DefaultWorkItemTimeout
  };

  #define EnumToCharCase(ENUM_VALUE) \
    case P_ ## ENUM_VALUE: \
    return #ENUM_VALUE;

  #define EnumToStringInsert(ENUM_VALUE) \
  mapping.insert(std::make_pair(std::string(#ENUM_VALUE),P_ ## ENUM_VALUE));

  static const char* toString(ParamId paramId)
  {
    switch(paramId)
    {
      EnumToCharCase(SortingBorder)
      EnumToCharCase(SleepTime)
      EnumToCharCase(AggregationMinNumThreads)
      EnumToCharCase(AggregationMaxNumThreads)
      EnumToCharCase(DefaultWorkItemTimeout)

      default:
        break;
    }
    return 0;
  }

  static ParamId toParamId(const std::string& name)
  {
    typedef std::map<std::string, ParamId> ParamIdMapType;
    static ParamIdMapType mapping;

    if(mapping.size() == 0)
    {
      EnumToStringInsert(SortingBorder)
      EnumToStringInsert(SleepTime)
      EnumToStringInsert(AggregationMinNumThreads)
      EnumToStringInsert(AggregationMaxNumThreads)
      EnumToStringInsert(DefaultWorkItemTimeout)
    }

    ParamIdMapType::const_iterator found = mapping.find(name);
    if(found != mapping.end())
      return found->second;
    else
      return P_Nothing;
  }

  #undef EnumToCharCase
  #undef EnumToStringInsert

  struct ParamBase
  {
    ParamId paramId;
  };
  template<class T>
  struct Param : public ParamBase
  {
    T data;
  };
}

#endif //SOFTSHELL_COMMUNICATOR_PARAMS_INCLUDED
