/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*   Rostislav Khlebnikov /  khlebnikov ( at ) icg.tugraz.at
*/

#ifndef SOFTSHELL_DISTRIBUTOR_DEFAULTCREATORPARAMS_H_INCLUDED
#define SOFTSHELL_DISTRIBUTOR_DEFAULTCREATORPARAMS_H_INCLUDED

#include "tools/types.h"
#include "distributor/deviceentries.h"
#include "distributor/eventworkpackagemanagement.h"



namespace Softshell
{
    template<class TWorkpackageParamsType = void>
    class
#if defined(__CUDACC__)
        __align__(16)
#elif  defined(_MSC_VER)
        __declspec(align(16))
#endif
        DefaultCreatorParams
    {
    public:
      typedef TWorkpackageParamsType WorkpackageParamsType;
      DefaultCreatorParams(dim workpackages, uint threads, const WorkpackageParamsType& workpackageParams, EventWorkpackageManagement ewm = EWM_LaunchLifetime) : ewm(ewm), workpackages_x(workpackages.x), workpackages_y(workpackages.y), workpackages_z(workpackages.z), threads(threads), workpackageParams(workpackageParams) {}
      DefaultCreatorParams(dim workpackages, uint threads, EventWorkpackageManagement ewm = EWM_LaunchLifetime) : ewm(ewm), workpackages_x(workpackages.x), workpackages_y(workpackages.y), workpackages_z(workpackages.z), threads(threads) {}

      EventWorkpackageManagement ewm;
      uint workpackages_x;
      uint workpackages_y;
      uint workpackages_z;
      uint threads;

      WorkpackageParamsType workpackageParams;
    }
#if defined(__GNUC__)
    __attribute__ ((aligned (16)))
#endif
        ;

     template<>
    class
#if defined(__CUDACC__)
        __align__(16)
#elif  defined(_MSC_VER)
        __declspec(align(16))
#endif
        DefaultCreatorParams<void>
    {
    public:
      typedef void* WorkpackageParamsType;

      DefaultCreatorParams(dim workpackages, uint threads, EventWorkpackageManagement ewm = EWM_LaunchLifetime) : ewm(ewm), workpackages_x(workpackages.x), workpackages_y(workpackages.y), workpackages_z(workpackages.z), threads(threads) {}

      EventWorkpackageManagement ewm;
      uint workpackages_x;
      uint workpackages_y;
      uint workpackages_z;
      uint threads;
    }
#if defined(__GNUC__)
    __attribute__ ((aligned (16)))
#endif
        ;
};

#endif //SOFTSHELL_DISTRIBUTOR_DEFAULTCREATORPARAMS_INCLUDED
