/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#ifndef SOFTSHELL_DISTRIBUTOR_DEVICE_H_INCLUDED
#define SOFTSHELL_DISTRIBUTOR_DEVICE_H_INCLUDED

#include <string>
#include <map>
#include "flags.h"
#include "tools/types.h"
#include "tools/thread.h"
#include "tools/configcollection.h"

namespace Softshell
{
  class HCommunicator;
  class HParams;
  class KernelIssuer;
  class TimeSync;
  class EventBase;
  class MappedMemory;
  class ControllerInfo;
  class Device
  {
    uint _deviceId;
    std::string name;
    HCommunicator* communicator;
    HParams* hparams;
    KernelIssuer* issuer;
    TimeSync* timesync;
    MappedMemory* mappedMemory;

    Mutex eventMutex;
    struct EventExecInfo
    {
      uint callCount;
      uint activeInstances;
      EventExecInfo() : callCount(0), activeInstances(0)
      {
      }
    };
    typedef std::map<uint, EventExecInfo> EventCallCountType;
    EventCallCountType eventCallCount;
    int activeEvents;

    Mutex stateMutex;
    bool running;
    ConfigCollection config;

    Signal joinedAll;
  public:
    Device(uint deviceId, const Flags& flags, ConfigCollection* config, const ControllerInfo * info = 0);
    ~Device();
    float calcScore(EventBase* event);

    uint deviceId() const;

    HCommunicator* getCommunicator();
    MappedMemory* getMappedMemory();

    void execEvent(uint eventId, uint eventLaunchId);
    void completedEvent(uint eventId, uint eventLaunchId, float time);

    const std::string & getName();

    void pause();
    void start();
    void shutdown();
    void join();

    template<class T>
    void setConfigParam(const std::string& name, T val)
    {
      config.set(name,val);
    }
    template<class T>
    T getConfigParam(const std::string& name)
    {
      return config.get<T>(name);
    }
  };

};


#endif //SOFTSHELL_DISTRIBUTOR_DEVICE_INCLUDED
