/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*   Rostislav Khlebnikov /  khlebnikov ( at ) icg.tugraz.at
*/

#ifndef SOFTSHELL_DISTRIBUTOR_DEVICEENTRIES_H_INCLUDED
#define SOFTSHELL_DISTRIBUTOR_DEVICEENTRIES_H_INCLUDED

#include "tools/types.h"
namespace Softshell
{
  class Workpackage;
  struct ExecState;

  typedef void(*DeviceEntryProcedureFunc)(Workpackage*);
  typedef void(*DeviceEntryCreatorDestroyerFunc)(uint eventId, uint eventLaunchId, void* creatorParams, void* &storage);

#define EntryProcedure(PROCNAME) \
  ((DeviceEntryProcedureFunc)PROCNAME::execute)

  //template<class Procedure>
  //__device__ void EntryProcedureR(Workpackage* wp)
  //{
  //  Procedure::execute(wp);
  //}

  template<class EventCreatorDestroyer>
  class EntryCreator {
  public:
      __device__ static void wrapped(uint eventId, uint eventLaunchId, void* creatorParam, void* &storage)
      {
          EventCreatorDestroyer::create(eventId, eventLaunchId,
              reinterpret_cast<typename EventCreatorDestroyer::CreatorParamsType*>(creatorParam),
              storage);
      }
  };

  template<class EventCreatorDestroyer>
  class EntryDestroyer {
  public:
      __device__ static void wrapped(uint eventId, uint eventLaunchId, void* creatorParam, void* &storage)
      {
        EventCreatorDestroyer::destroy(eventId, eventLaunchId,
            reinterpret_cast<typename EventCreatorDestroyer::CreatorParamsType*>(creatorParam),
            storage);
      }
  };

};


#endif //SOFTSHELL_DISTRIBUTOR_DEVICEENTRIES_INCLUDED
