/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*   Rostislav Khlebnikov /  khlebnikov ( at ) icg.tugraz.at
*/

#ifndef SOFTSHELL_DISTRIBUTOR_DEVICEPOINTERLIST_H_INCLUDED
#define SOFTSHELL_DISTRIBUTOR_DEVICEPOINTERLIST_H_INCLUDED

#include "distributor/deviceentries.h"
#include "tools/types.h"
#include "tools/thread.h"

#ifndef __GNUC__
#include <unordered_map>
#else
#include <map>
#endif
#include <iostream>
#include <typeinfo>

#ifdef __CUDACC__
#include "distributor/deviceentries.cuh"
#endif

namespace Softshell
{
  template<class ToWrap>
  class EntryWrapper
  {
    public:
    //static std::map<uint, uint> deviceMappings;
    static uint myid;
    static uint generate(uint &nextFreeVal)
    {
      //auto found = deviceMappings.find(deviceId);
      //if(found == deviceMappings.end())
      //  found = deviceMappings.insert(std::make_pair(deviceId, ++nextFreeVal)).first;
      //return found->second;
      if(myid == 0)
        myid = ++nextFreeVal;
      return myid;
    }
  };
  template<class ToWrap>
  //std::map<uint, uint> EntryWrapper<ToWrap>::deviceMappings;
  uint EntryWrapper<ToWrap>::myid = 0;

  class DevicePointerList
  {

    //typedef CombinedKey<uint,DeviceEntryProcedureFunc> ProcedureMappingKey;
    //std::unordered_map<ProcedureMappingKey,DeviceEntryProcedureFunc> procedure_mapping;
    typedef std::pair<DeviceEntryCreatorDestroyerFunc, DeviceEntryCreatorDestroyerFunc> CDFpair;
    typedef std::map<uint,CDFpair> CreatorDestroyerInnerMappingType;
#ifndef __GNUC__
    typedef std::unordered_map<uint, CreatorDestroyerInnerMappingType> CreatorDestroyerMappingType;
#else
    typedef std::map<uint, CreatorDestroyerInnerMappingType > CreatorDestroyerMappingType;
#endif
    CreatorDestroyerMappingType creator_destroyer_mapping;
    uint nextFreeVal;

    Mutex mutex;

    void prepareRetreivePointer(uint deviceId)
    {
      //TODO: stop megakernel if running
      cudaSetDevice(deviceId);
    }
    void releaseRetreivePointer(uint deviceId)
    {
      //TODO: start megakernel if stopped
    }

#if __CUDACC__
    template<class TEventCreatorDestroyer>
    inline std::pair<DeviceEntryCreatorDestroyerFunc, DeviceEntryCreatorDestroyerFunc> getDeviceFunctionCreatorDestroyerPointer(uint deviceId)
    {
        Guard g(mutex);
        uint finder = EntryWrapper<TEventCreatorDestroyer>::generate(nextFreeVal);
        CreatorDestroyerMappingType::iterator found = creator_destroyer_mapping.find(finder);

        if(found != creator_destroyer_mapping.end())
        {
          CreatorDestroyerInnerMappingType::const_iterator found2 = found->second.find(deviceId);
          if(found2 != found->second.end())
            return found2->second;
        }
        else
          found = creator_destroyer_mapping.insert(std::make_pair(finder, std::map<uint,CDFpair>())).first;


        prepareRetreivePointer(deviceId);
        DeviceEntryCreatorDestroyerFunc creator = readDeviceFunctionPointer<DeviceEntryCreatorDestroyerFunc, TEventCreatorDestroyer, EntryCreator>();
        DeviceEntryCreatorDestroyerFunc destroyer = readDeviceFunctionPointer<DeviceEntryCreatorDestroyerFunc, TEventCreatorDestroyer, EntryDestroyer>();
        releaseRetreivePointer(deviceId);

        std::pair<DeviceEntryCreatorDestroyerFunc, DeviceEntryCreatorDestroyerFunc> res = std::make_pair(creator, destroyer);
        found->second.insert(std::make_pair(deviceId, res));

        return res;
    }
#endif

  public:
    DevicePointerList() : nextFreeVal(0)
    {
    }
#if __CUDACC__
    template<class TEventCreatorDestroyer>
    DeviceEntryCreatorDestroyerFunc getCreatorFunc(uint deviceId)
    {
       std::pair<DeviceEntryCreatorDestroyerFunc, DeviceEntryCreatorDestroyerFunc> res = getDeviceFunctionCreatorDestroyerPointer<TEventCreatorDestroyer>(deviceId);
       return res.first;
    }

    template<class TEventCreatorDestroyer>
    DeviceEntryCreatorDestroyerFunc getDestroyerFunc(uint deviceId)
    {
        std::pair<DeviceEntryCreatorDestroyerFunc,DeviceEntryCreatorDestroyerFunc> res = getDeviceFunctionCreatorDestroyerPointer<TEventCreatorDestroyer>(deviceId);
        return res.second;
    }
#endif


  };
};


#endif //SOFTSHELL_DISTRIBUTOR_DEVICEPOINTERLIST_INCLUDED
