/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*   Rostislav Khlebnikov /  khlebnikov ( at ) icg.tugraz.at
*/

#ifndef SOFTSHELL_DISTIBUTOR_EVENT_IPP_INCLUDED
#define SOFTSHELL_DISTIBUTOR_EVENT_IPP_INCLUDED

#include "distributor/devicepointerlist.h"
#include "distributor/defaultcreatorparams.h"
#include "distributor/event_impl.h"

namespace Softshell
{
  template<class TEventCreatorDestroyer>
  Event<TEventCreatorDestroyer>::Event(HScheduler* scheduler)
    : devicepointerlist(scheduler->devicepointerlist)
  {
    pImpl = new EventImpl<TEventCreatorDestroyer>(scheduler, this);
  }

  template<class TEventCreatorDestroyer>
  Event<TEventCreatorDestroyer>::~Event()
  {
    delete pImpl;
  }

#if __CUDACC__
  template<class TEventCreatorDestroyer>
  uint Event<TEventCreatorDestroyer>::fire(const CreatorParamsType& creatorParams, Device* device)
  {
    uint deviceId = pImpl->chooseDevice(device);

    DeviceEntryCreatorDestroyerFunc creator = devicepointerlist->getCreatorFunc<TEventCreatorDestroyer>(deviceId);
    DeviceEntryCreatorDestroyerFunc destroyer = devicepointerlist->getDestroyerFunc<TEventCreatorDestroyer>(deviceId);
    return pImpl->fired(creatorParams, creator, destroyer, deviceId);
  }
#endif

  template<class TEventCreatorDestroyer>
  void Event<TEventCreatorDestroyer>::done(uint launchId, Device* dev, float time)
  {
    pImpl->done(launchId, dev, time);
  }

  template<class TEventCreatorDestroyer>
  uint Event<TEventCreatorDestroyer>::getId() const
  {
    return pImpl->getId();
  }

  template<class TEventCreatorDestroyer>
  void Event<TEventCreatorDestroyer>::join()
  {
    pImpl->join();
  }
  template<class TEventCreatorDestroyer>
  void Event<TEventCreatorDestroyer>::join(uint id)
  {
    pImpl->join(id);
  }

  template<class TEventCreatorDestroyer>
  void Event<TEventCreatorDestroyer>::cancel()
  {
    pImpl->cancel();
  }
  template<class TEventCreatorDestroyer>
  void Event<TEventCreatorDestroyer>::cancel(uint id)
  {
    pImpl->cancel(id);
  }

  template<class TEventCreatorDestroyer>
  uint Event<TEventCreatorDestroyer>::getNumActiveLaunches() const
  {
    return pImpl->getNumActiveLaunches();
  }

  template<class TEventCreatorDestroyer>
  std::vector<EventStatistics> Event<TEventCreatorDestroyer>::getEventStatus() const
  {
    return pImpl->getEventStatus();
  }

  template<class TEventCreatorDestroyer>
  void Event<TEventCreatorDestroyer>::setPeriodicity(float periodicity)
  {
    pImpl->setPeriodicity(periodicity);
  }

  template<class TEventCreatorDestroyer>
  void Event<TEventCreatorDestroyer>::setDeadline(float deadline)
  {
    pImpl->setDeadline(deadline);
  }

  template<class TEventCreatorDestroyer>
  void Event<TEventCreatorDestroyer>::setPriority(Priority priority)
  {
    pImpl->setPriority(priority);
  }

  template<class TEventCreatorDestroyer>
  void Event<TEventCreatorDestroyer>::registerNotifier(EventNotifier* notifier)
  {
    pImpl->registerNotifier(notifier);
  }

  template<class TEventCreatorDestroyer>
  void Event<TEventCreatorDestroyer>::unregisterNotifier(EventNotifier* notifier)
  {
    pImpl->unregisterNotifier(notifier);
  }

  template<class TEventCreatorDestroyer>
  double Event<TEventCreatorDestroyer>::getExecTime(uint id)
  {
    return pImpl->getExecTime(id);
  }


  template<typename CreatorParamsType>
  uint PEvent_Interface::getTypeId()
  {
    static uint myid = 0;
    if(myid == 0)
        myid = getLastTypeCounter()++;
    return myid;
  }

#ifndef WIN32
  template<class TEventCreatorDestroyer>
  PEvent_Implementation<TEventCreatorDestroyer>::PEvent_Implementation(Event<TEventCreatorDestroyer>* event) : event(event), myid(  PEvent_Interface::getTypeId<typename TEventCreatorDestroyer::CreatorParamsType>())
  {
  }
#else
 template<class TEventCreatorDestroyer>
  PEvent_Implementation<TEventCreatorDestroyer>::PEvent_Implementation(std::shared_ptr<Event<TEventCreatorDestroyer> > event) : event(event), myid( PEvent_Interface::getTypeId<typename TEventCreatorDestroyer::CreatorParamsType>() )
  {
  }
#endif


  template<class TEventCreatorDestroyer>
  uint PEvent_Implementation<TEventCreatorDestroyer>::fire(const void* creatorParams, uint creatorParamsTypeId, Device* device)
  {
    if(creatorParamsTypeId != myid)
      throw std::runtime_error("Error in Event::fire: param CreatorParamsTypes do not match\n");
    return event->fire(*reinterpret_cast<typename TEventCreatorDestroyer::CreatorParamsType const *>(creatorParams), device);
  }


  template<class TEventCreatorDestroyer>
  PEvent_Interface* PEvent_Implementation<TEventCreatorDestroyer>::clone() const
  {
    PEvent_Interface* out =  new PEvent_Implementation(*this);
#ifndef WIN32
    event = nullptr;
#endif
    return out;
  }

  template<class TEventCreatorDestroyer>
  PEvent_Implementation<TEventCreatorDestroyer>::~PEvent_Implementation()
  {
#ifndef WIN32
    delete event;
#endif
  }
};

#endif //SOFTSHELL_DISTIBUTOR_EVENTIPP_INCLUDED
