/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*   Rostislav Khlebnikov /  khlebnikov ( at ) icg.tugraz.at
*/

#ifndef SOFTSHELL_DISTIBUTOR_EVENTIMPL_H_INCLUDED
#define SOFTSHELL_DISTIBUTOR_EVENTIMPL_H_INCLUDED

#include "api/scheduler.h"
#include "api/event.h"
#include "tools/idmanager.h"
#include "communicator/hcommunicator.h"
#include "tools/types.h"
#include "tools/thread.h"

#include <set>
#include <map>


namespace Softshell
{
  class HScheduler;
  template<class TEventCreatorDestroyer>
  class EventImpl
  {
  public:
    typedef typename TEventCreatorDestroyer::CreatorParamsType CreatorParamsType;
    friend class Event<TEventCreatorDestroyer>;

  protected:
    Event<TEventCreatorDestroyer>* owner;
    Mutex joinerMutex;
    Signal joinedAll;
    struct LaunchData
    {
      Signal signal;
      std::pair<void*,void*> allocatedMemory;
      LaunchData(std::pair<void*,void*> allocatedMem = std::make_pair<void*,void*>(nullptr,nullptr)) : allocatedMemory(allocatedMem) { }
    };
    typedef std::map<uint, LaunchData > ActiveLaunchesType;
    //std::map<uint, LaunchData> activeLaunches;
    ActiveLaunchesType activeLaunches;

    uint fired(const CreatorParamsType& creatorParams,
               DeviceEntryCreatorDestroyerFunc EventCreator,
               DeviceEntryCreatorDestroyerFunc EventDestroyer, uint deviceId);
    uint chooseDevice(Device* device);

    HScheduler* hscheduler;
    const uint id;

    Mutex notifierMutex;
    typedef std::set<EventNotifier*> NotifiersType;
    NotifiersType notifiers;
    typedef std::map<uint, double> ExecTimesType;
    ExecTimesType  execTimes;

  public:
    EventImpl(HScheduler* hscheduler, Event<TEventCreatorDestroyer>* owner);
    ~EventImpl();

    void join();
    void join(uint id);
    void cancel();
    void cancel(uint id);

    uint getNumActiveLaunches() const;
    std::vector<EventStatistics> getEventStatus() const;

    void registerNotifier(EventNotifier* notifier);
    void unregisterNotifier(EventNotifier* notifier);

    void setPeriodicity(float periodicity);
    void setDeadline(float deadline);
    void setPriority(Priority priority);

    double getExecTime(uint id);

    void done(uint launchId, Device* device, float time);
    uint getId() const { return id; }
  };
};

#include "event_impl.ipp"

#endif //SOFTSHELL_DISTIBUTOR_EVENTIMPL_INCLUDED
