/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*   Rostislav Khlebnikov /  khlebnikov ( at ) icg.tugraz.at
*/

#ifndef SOFTSHELL_DISTIBUTOR_EVENTCOMMUNICATOR_CUH_INCLUDED
#define SOFTSHELL_DISTIBUTOR_EVENTCOMMUNICATOR_CUH_INCLUDED

#include "distributor/eventmanager.cuh"
#include "communicator/dcommunicator.cuh"
#include "deviceentries.h"

namespace Softshell
{
  class EventCommunicator : public DMessageReceiver
  {
  public:
    __device__ EventCommunicator(DCommunicator* communicator)
    {
      communicator->registerMessageReceiver(this, H2D_FireEvent);
      communicator->registerMessageReceiver(this, H2D_EventPriority);
      communicator->registerMessageReceiver(this, H2D_EventPeriodicity);
      communicator->registerMessageReceiver(this, H2D_EventDeadline);
    }
    __device__ void receiveMessage(MessageHeader& h, volatile uint* data, uint linid, uint threads)
    {
      switch(h.id)
      {
        case H2D_FireEvent:
        {
          volatile EventData* edata = reinterpret_cast<volatile EventData*>(data);
          //if(linid == 0)
          //  printf("should start event: %d %d %llx %llx %llx\n",edata->eventId,
          //  edata->eventLaunchId,
          //  edata->destroyer,
          //  edata->creator,
          //  edata->creatorParams);
          //__syncthreads();

          d_eventManager.newEventLaunch(edata);
        }
        break;
        case H2D_EventPriority:
          d_eventManager.setPriority(data[0],*(Priority*)(data+1),false);
          break;
        case H2D_EventPeriodicity:
          d_eventManager.setPeriodicity(data[0],*(float*)(data+1),false);
          break;
        case H2D_EventDeadline:
          d_eventManager.setDeadline(data[0],*(float*)(data+1),false);
          break;
      }
    }
  };
}

#endif //SOFTSHELL_DISTIBUTOR_EVENTCOMMUNICATOR_INCLUDED
