/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#include "eventlist.h"
#include "device.h"
#include "event_impl.h"

namespace Softshell
{
    EventList* EventList::instance;

 

    uint EventList::requestLaunchId(EventBase* requester)
    {
      return eventLaunchIdManager.request(requester);
    }
    uint EventList::requestId(EventBase* event)
    {
      return eventIdManager.request(event);
    }
    void EventList::destroyed(EventBase* event)
    {
      eventIdManager.remove(event->getId());
    }


    //Message Receiver
    uint EventList::numReceivingMessages() const
    {
      return 1;
    }
    uint EventList::receivingMessageId(uint i) const
    {
      if(i == 0)
        return D2H_EventLaunchDone;
      return D2H_ERROR;
    }
    void EventList::receiveMessage(MessageHeader& h, uint* data, HCommunicator* communicator, Device* source)
    {
      if(h.id == D2H_EventLaunchDone)
      {
        uint eventId = *data++;
        uint eventLaunchId = *data++;
        float time = *reinterpret_cast<float*>(data);
        //printf("eventlaunch done: %d %d\n",eventId, eventLaunchId);
        
        EventBase* launchFound = eventLaunchIdManager.find(eventLaunchId);
        EventBase* eventFound = eventIdManager.find(eventId);

        //avoid double done
        if(launchFound != 0) 
        {
          eventLaunchIdManager.remove(eventLaunchId);
          source->completedEvent(eventId, eventLaunchId,  time);
          if(eventFound)
            eventFound->done(eventLaunchId, source, time);
        }
        else
          printf("did not find: %d %d\n",eventId,eventLaunchId);
      }
    }
    void EventList::addDevice(Device* device)
    {
      device->getCommunicator()->registerMessageReceiver(this);
    }
} 