/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*   Rostislav Khlebnikov /  khlebnikov ( at ) icg.tugraz.at
*/

#ifndef SOFTSHELL_DISTIBUTOR_EVENTMANAGER_CUH_INCLUDED
#define SOFTSHELL_DISTIBUTOR_EVENTMANAGER_CUH_INCLUDED

#include "api/priority.h"
#include "distributor/deviceentries.h"
#include "distributor/eventworkpackagemanagement.h"
#include "communicator/dcommunicator.cuh"
#include "distributor/eventData.h"
#include "timing/timesync.cuh"

namespace Softshell
{
  class DEvent;
  struct EventInfo
  {
    float periodicity;
    float deadline;
    Priority priority;
    void* storage;
    //TODO statistics

    __device__ void init()  volatile
    {
      periodicity = 0;
      deadline = 0;
      priority = normal;
      storage = 0;
    }
  };
  struct EventLaunchInfo
  {
    DeviceEntryCreatorDestroyerFunc destroyer;
    void* creatorParams;
    void* storage;
    double starttime;
    clock64_t startcycles;
    int activeworkpackagecount;
    int processedworkpackagecount;
    uint eventId;

    __device__ void init() volatile
    {
      activeworkpackagecount = 0;
      processedworkpackagecount = 0;
    }
  };
  class EventManager
  {
    static const uint EventListSize = 128;
    static const uint EventLaunchListSize = 1024;

    volatile EventInfo eventInfos[EventListSize];
    volatile EventLaunchInfo eventLaunchInfos[EventLaunchListSize];

    //debug
    //volatile int WorkItemCounter[1024];
    //debug
  public:

    inline __device__ void init();

    __forceinline__ __device__ Priority getPriority(uint eventId) const;
    __forceinline__ __device__ void setPriority(uint eventId, Priority priority, bool informHost = true);
    __forceinline__ __device__ float getDeadline(uint eventId) const;
    __forceinline__ __device__ void setDeadline(uint eventId, float deadline, bool informHost = true);
    __forceinline__ __device__ float getPeriodicity(uint eventId) const;
    __forceinline__ __device__ void setPeriodicity(uint eventId, float periodicity, bool informHost = true);

    __forceinline__ __device__ double getLaunchTime(uint eventLaunchId) const;
    __forceinline__ __device__ int getActiveWorkpackages(uint eventLaunchId) const;
    __forceinline__ __device__ int getProcessedWorkpackages(uint eventLaunchId) const;

    __forceinline__ __device__ void newWorkpackagesForEvent(const DEvent& devent, int num = 1);
    __forceinline__ __device__ void newWorkpackagesForEvent(uint eventId, uint eventLaunchId, int num = 1);
    __forceinline__ __device__ void finishedWorkpackagesForEvent(volatile DEvent& devent, int num = 1);
    __forceinline__ __device__ void finishedWorkpackagesForEvent(uint eventId, uint eventLaunchId, int num = 1);

    __forceinline__ __device__ void newEventLaunch(volatile EventData* eventData);

    inline __device__ void debugEventLaunchInfo(uint info);
    //inline __device__ void debugWorkItemCounter();
    //inline __device__ void debugWorkItemCounterAdd(int num);
  };

  extern __device__ EventManager d_eventManager;
}

#include "distributor/eventmanager.ipp"



#endif
