/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*   Rostislav Khlebnikov /  khlebnikov ( at ) icg.tugraz.at
*/

#ifndef SOFTSHELL_DISTRIBUTOR_HSCHEDULER_INCLUDED
#define SOFTSHELL_DISTRIBUTOR_HSCHEDULER_INCLUDED

#include <map>
#include <vector>
#include "distributor/device.h"
#include "flags.h"
#include "hscheduler.cuh"
#include "tools/types.h"
#include "tools/configcollection.h"

namespace Softshell
{
  class ControllerInfo;
  class DevicePointerList;
  class HScheduler
  {
  public:
    typedef std::map<Device*, uint> DeviceToIDMappingType;
    DeviceToIDMappingType deviceToIdMapping;

    typedef std::map<uint, Device*> IDToDeviceMappingType;
    IDToDeviceMappingType idToDeviceMapping;
    DevicePointerList* devicepointerlist;
    ConfigCollection* config;

    HScheduler(DevicePointerList* _devicepointerlist, ConfigCollection* _config);

    Device* getDevice(uint deviceId)
    {
      IDToDeviceMappingType::const_iterator found = idToDeviceMapping.find(deviceId);
      if(found != idToDeviceMapping.end())
        return found->second;
      else
        return 0;
    }

    std::vector<uint> initDevices(uint deviceId, const Flags& flags, const ControllerInfo* info = 0);
    std::vector<uint> initDevices(std::vector<uint> const & devicelist, const Flags& flags, const ControllerInfo* info = 0);

    void reset();
  };
}
#endif
