/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*   Rostislav Khlebnikov /  khlebnikov ( at ) icg.tugraz.at
*/

#ifndef SOFTSHELL_DISTIBUTOR_PROCEDUREMANAGER_INCLUDED
#define SOFTSHELL_DISTIBUTOR_PROCEDUREMANAGER_INCLUDED

#include "tools/types.h"
#include "stdlib/unordered_map.cuh"
#include "distributor/deviceentries.h"

namespace Softshell
{

  class ProcedureInfo
  {
    DeviceEntryProcedureFunc procFunction;
  public:
    float creationRatio;
    uint customId;
    uint execThreads;
    uint sharedMem;
    uint sharedMemPerThread;

    template<class PROCEDURE>
    static __device__ ProcedureInfo create()
    {
      ProcedureInfo info;
      info.procFunction = EntryProcedure(PROCEDURE);
      info.customId = PROCEDURE::CustomId;
      info.execThreads = PROCEDURE::ExecThreads;
      info.sharedMem = PROCEDURE::sharedMem();
      info.sharedMemPerThread = PROCEDURE::sharedMemPerThread();
      return info;
    }

    template<class PROCEDURE>
    __device__ bool equals()
    {
      return PROCEDURE::execute == procFunction;
    }
  };
  class ProcedureManager
  {

    typedef std_gpu::_unordered_map<DeviceEntryProcedureFunc,ProcedureInfo,1024> ProceduresMap;
     ProceduresMap procedures;
  public:
   __device__ void init(uint linId, uint threads)
    {
      procedures.init(linId, threads);
    }

    template<class PROCEDURE>
    __device__ void ensureAvailability()
    {
      DeviceEntryProcedureFunc f = EntryProcedure(PROCEDURE);
      if(procedures.find(f) == procedures.end())
        procedures.insert(std_gpu::make_pair(f,ProcedureInfo::create<PROCEDURE>()));
      ProceduresMap::Iterator found = procedures.find(f);
    }
    __device__ ProcedureInfo* get(DeviceEntryProcedureFunc procedureFunc)
    {
      ProceduresMap::Iterator found = procedures.find(procedureFunc);
      if(found == procedures.end())
        return 0;
      return &found->second;
    }
    template<class PROCEDURE>
    __device__ ProcedureInfo* get()
    {
      DeviceEntryProcedureFunc f = EntryProcedure(PROCEDURE);
      if(f == 0) return 0;
      ProcedureInfo* res = get(f);

      if(res == 0)
      {
        std_gpu::pair<ProceduresMap::Iterator,bool> insertres = procedures.insert(std_gpu::make_pair(f,ProcedureInfo::create<PROCEDURE>()));
        res = &insertres.first->second;
      }
      return res;
    }


  };
  extern __device__ ProcedureManager *d_procedureManager;
}




#endif //SOFTSHELL_DISTIBUTOR_PROCEDUREMANAGER_INCLUDED
