/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#ifndef SOFTSHELL_MEGAKERNEL_MEGAKERNEL_INCLUDED
#define SOFTSHELL_MEGAKERNEL_MEGAKERNEL_INCLUDED

#include "tools/utils.h"
#include "tools/types.h"
#include "megakernel/controller.h"
#include "flags.h"
#include <cstdio>

namespace Softshell
{
  class HParams;
  void initLaunchStates(HParams*);
  void initEventManager(HParams*);
  void initProcedureManager(HParams*);
  void initScatterAlloc(uint memsize);
  void initDScheduler(HParams*);
  void initMegakernalConstants(HParams*);
  void initDParams(HParams*);
  void initAggregation(HParams*);
  void initRoundRobinAlloc(HParams* params);
#ifdef __CUDACC__
  extern __constant__ uint runningThreads;
  __global__ void d_megakernel(uint launchId, ControllerFunc controllerfunc, uint sortingThreads, uint additionalSharedMemory, uint MaxConcurrentWorkpackages, uint GroupSize);
  __global__ void d_separate_worker(uint launchId, uint additionalSharedMemory, uint NumGroups, uint GroupSize);
  __global__ void d_megakernel_simple(uint launchId, ControllerFunc controllerfunc, uint sortingThreads, uint additionalSharedMemory);
  __global__ void d_separate_worker_simple(uint launchId, uint additionalSharedMemory);
  template<class, bool, bool>
  __global__ void d_megakernel_simple_def_controller(uint launchId, uint sortingThreads, uint additionalSharedMemory);
  template<class, bool, bool>
  __global__ void d_megakernel_def_controller(uint launchId, uint sortingThreads, uint additionalSharedMemory, uint NumGroups, uint GroupSize);

#endif

  inline void prepareDevice(const Flags& flags)
  {
    uint heapsize = 24U*1024U*1024U;
    Flags::const_iterator found = flags.find(FL_HeapSize);
    if(found != flags.end())
    {
      std::stringstream sstr(found->second);
      sstr >> heapsize;
      // variant not working on Linux
      //heapsize = std::stoul(found->second);
    }
#ifndef USE_CUDA_HEAP
    cudaDeviceProp props;
    int dev;
    cudaGetDevice(&dev);
    cudaGetDeviceProperties(&props,dev);
    if(props.totalGlobalMem/2 < heapsize)
      printf("WARNING using more than half of global memory for dynamic memory allocation (dynamic memory: %lu available memory: %u ratio: %f\n  consider reducing \"HeapSize\"!\n",props.totalGlobalMem,heapsize,heapsize/(float)props.totalGlobalMem);
    initScatterAlloc(heapsize);
#endif
  }

  inline void initMegaKernel(const Flags& flags, HParams* hparams)
  {
    initLaunchStates(hparams);
    initDScheduler(hparams);
    initMegakernalConstants(hparams);
    initEventManager(hparams);
    initProcedureManager(hparams);
    initDParams(hparams);
    initAggregation(hparams);
    initRoundRobinAlloc(hparams);
  }
}


#endif //SOFTSHELL_MEGAKERNEL_MEGAKERNEL_CUH_INCLUDED
