/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#include "memory/UseScatterAlloc.cuh"
#include "tools/utils.h"
#include <iostream>

#if defined(__CUDACC__) && !defined(USE_CUDA_HEAP) && __CUDA_ARCH__ >= 200
#ifndef WIN32
__device__ void* malloc(size_t t) __THROW
#else
__device__ void* malloc(size_t t)
#endif
{
  void* res = Softshell::theHeap.alloc(t);
  return res;
}
#ifndef WIN32
__device__ void  free(void* p) __THROW
#else
__device__ void  free(void* p)
#endif
{
  Softshell::theHeap.dealloc(p);
}
#endif

namespace Softshell
{
#ifndef USE_CUDA_HEAP
  __device__  DeviceHeap<5*4096> theHeap;

  /**
    * global init heap method
    */
  __global__ void initHeap(void* heapmem, uint memsize)
  {
    theHeap.init(heapmem, memsize);
  }
#endif
  void initScatterAlloc(uint memsize)
  {
#ifndef USE_CUDA_HEAP
    void* mem;
    CUDA_CHECKED_CALL(cudaMalloc(&mem,memsize));
    initHeap<<<128,256>>>(mem, memsize);
    CUDA_CHECKED_CALL(cudaDeviceSynchronize());
#endif
  }

  __device__ uint d_scatterAllocCounter;
  __global__ void d_ScatterAllocReport(uint memsize = 0)
  {
    theHeap.reportFree(&d_scatterAllocCounter, memsize);
  }
  uint scatterAllocReport(uint memsize)
  {
    uint res = 0;
    CUDA_CHECKED_CALL(cudaMemcpyToSymbol(d_scatterAllocCounter, &res, sizeof(uint)));
    d_ScatterAllocReport<<<64,256>>>(memsize);
    CUDA_CHECKED_CALL(cudaMemcpyFromSymbol(&res, d_scatterAllocCounter, sizeof(uint)));
    return res;
  }
}

