/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#ifndef USESCATTERALLOC_INCLUDED
#define USESCATTERALLOC_INCLUDED

#include "memory/ScatterAlloc.cuh"

namespace Softshell
{
#ifndef USE_CUDA_HEAP
   template class DeviceHeap<5*4096>;
   extern __device__ DeviceHeap<5*4096> theHeap;
#endif
}

#ifdef __CUDACC__
#ifndef USE_CUDA_HEAP
#if __CUDA_ARCH__ >= 200
#ifndef WIN32
extern __device__ void* malloc(size_t t) __THROW __attribute_malloc__ __wur;
extern __device__ void  free(void* p) __THROW;
#else
extern __device__ void* malloc(size_t t);
extern __device__ void  free(void* p);
#endif
//inline __device__ void* malloc(size_t t)
//{
//  printf("alloc %d\n",t);
//  return Softshell::theHeap.alloc(t);
//}
//inline __device__ void  free(void* p)
//{
//  Softshell::theHeap.dealloc(p);
//}
#define sNew new
#define sNewA new
#define sDelete(what) delete what
#define sDeleteA(what) delete what
#endif
#else
#define sNew new(theHeap)
#define sNewA new(theHeap)
#define sDelete(what) theHeap.deleteS(what)
#define sDeleteA(what) theHeap.deleteA(what)
template<uint pagesize, uint accessblocks, uint regionsize, uint wastefactor, bool use_coalescing, bool resetfreedpages>
inline __device__ void* operator new(size_t bytes, Softshell::DeviceHeap<pagesize, accessblocks,  regionsize, wastefactor, use_coalescing, resetfreedpages> &h )
{
  return h.alloc(bytes);
}
template<uint pagesize, uint accessblocks, uint regionsize, uint wastefactor, bool use_coalescing, bool resetfreedpages>
inline __device__ void* operator new[](size_t bytes, Softshell::DeviceHeap<pagesize, accessblocks,  regionsize, wastefactor, use_coalescing, resetfreedpages> &h )
{
  return h.alloc(bytes);
}
template<uint pagesize, uint accessblocks, uint regionsize, uint wastefactor, bool use_coalescing, bool resetfreedpages>
inline __device__ void operator delete(void* mem, Softshell::DeviceHeap<pagesize, accessblocks,  regionsize, wastefactor, use_coalescing, resetfreedpages> &h )
{
  h.dealloc(mem);
}
template<uint pagesize, uint accessblocks, uint regionsize, uint wastefactor,  bool use_coalescing, bool resetfreedpages>
inline __device__ void operator delete[](void* mem, Softshell::DeviceHeap<pagesize, accessblocks,  regionsize, wastefactor, use_coalescing, resetfreedpages> &h )
{
  h.dealloc(mem);
}
#endif
#endif //__CUDACC__
#endif
