/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#include "memory/roundrobinalloc.cuh"
#include "communicator/hparams.h"
#include "tools/common.cuh"

namespace Softshell
{

  namespace RoundRobinAlloc
  {
    __constant__ uint wpUseRoundRobinAlloc;
    __constant__ uint size_mask;
    __constant__ void* memory;
    __device__ uint offset;
  }
  void WorkpackageUseRoundRobinAllocUp(const std::string& name, bool& value, int* pd)
  {
    int dev = *reinterpret_cast<int*>(&pd);
    cudaSetDevice(dev);
    uint v = value;
    cudaMemcpyToSymbol(RoundRobinAlloc::wpUseRoundRobinAlloc, &v, sizeof(uint));
  }
  void initRoundRobinAlloc(HParams* params)
  {
    Config* config = params->getConfig();
    uint memsize = config->registerConfig("RoundRobinMemSize",2u*1024u*1024u);
    uint memexp = 0;
    while(1 << memexp < memsize) ++memexp;
    memsize = 1 << memexp;
    uint memmask = memsize- 1;

    int dev;
    cudaGetDevice(&dev);
    int* pd = (int*)(dev);
    uint use = config->registerConfig("WorkpackageUseRoundRobinAlloc",false, WorkpackageUseRoundRobinAllocUp,pd);

    void *pMemory;
    CUDA_CHECKED_CALL(cudaMalloc(&pMemory, memsize));

    uint null = 0;
    cudaMemcpyToSymbol(RoundRobinAlloc::wpUseRoundRobinAlloc, &use, sizeof(uint));
    cudaMemcpyToSymbol(RoundRobinAlloc::size_mask, &memmask, sizeof(uint));
    cudaMemcpyToSymbol(RoundRobinAlloc::memory, &pMemory, sizeof(void*));
    cudaMemcpyToSymbol(RoundRobinAlloc::offset, &null, sizeof(uint));
  }
}
