/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#ifndef SOFTSHELL_MEMORY_ROUNDROBINALLOC_INCLUDED
#define SOFTSHELL_MEMORY_ROUNDROBINALLOC_INCLUDED

#include "tools/common.cuh"

namespace Softshell
{
  
  namespace RoundRobinAlloc
  {
    extern __constant__ uint wpUseRoundRobinAlloc;
    extern __constant__ uint size_mask;
    extern __constant__ void* memory;
    extern __device__ uint offset;

    inline __device__ void* alloc(uint req_size)
    {
      req_size = (req_size + 15) & 0xFFFFFFF0;
      uint old = atomicAdd(&offset,req_size) & size_mask;
      if(((old + req_size) & size_mask) < old)
        old = atomicAdd(&offset,req_size) & size_mask;
      return (void*)(((unsigned char*)memory) + old);
    }

    inline __device__ void* wpCheckedAlloc(uint req_size)
    {
      if(RoundRobinAlloc::wpUseRoundRobinAlloc)
        return RoundRobinAlloc::alloc(req_size);
      else
        return malloc(req_size);
    }
    inline __device__ void wpCheckedFree(void* p)
    {
      if(RoundRobinAlloc::wpUseRoundRobinAlloc)
        return;
      else
        free(p);
    }
  }

}





#endif