/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#ifndef SOFTSHELL_QUEUE_DSCHEDULER_INCLUDED
#define SOFTSHELL_QUEUE_DSCHEDULER_INCLUDED

#include "tools/utils.h"
#include "distributor/deviceentries.h"
#include "queue/queue.cuh"
#include "megakernel/execstate.cuh"
#include "distributor/eventmanager.cuh"
#include "api/workpackage.h"
#include "distributor/proceduremanager.cuh"

namespace Softshell
{

  extern __device__ Queue d_queue;

  template<class PROCEDURE>
  __device__ static inline void enqueueWorkpackage(Workpackage* workpackage, uint forThreads = 0)
  {
    if(PROCEDURE::ExecThreads != 0)
       forThreads = PROCEDURE::ExecThreads;
    if(forThreads == 0)
       forThreads = runningThreads;
    d_queue.enqueue(workpackage, EntryProcedure(PROCEDURE), forThreads);
  }

  template<class PROCEDURE>
  __device__ static inline void enqueueWorkpackage(BlockWorkpackage* workpackage, uint forThreads = 0)
  {
    if(PROCEDURE::ExecThreads != 0)
       forThreads = PROCEDURE::ExecThreads;
    if(forThreads == 0)
      forThreads = workpackage->numThreads;
    if(forThreads == 0)
       forThreads = runningThreads;
    d_queue.enqueue(workpackage, EntryProcedure(PROCEDURE), forThreads);
  }

  __device__ static inline void enqueueWorkpackage(Workpackage* workpackage, DeviceEntryProcedureFunc proc, uint forThreads)
  {
    d_queue.enqueue(workpackage, proc, forThreads);
  }
  

  template<class PROCEDURE, class WORKPACKAGE>
  __device__ static inline void emitWorkpackage(volatile WORKPACKAGE* workpackage, uint forThreads = 0)
  {
    WORKPACKAGE* tworkpackage = const_cast<WORKPACKAGE*>(workpackage);
    d_procedureManager->ensureAvailability<PROCEDURE>();
    enqueueWorkpackage<PROCEDURE>(tworkpackage,forThreads);
    d_eventManager.newWorkpackagesForEvent(workpackage->getEventId(), workpackage->getEventLaunchId());
  }
  template<class PROCEDURE, class WORKPACKAGE>
  __device__ static inline void emitSingleWorkpackage(WORKPACKAGE* workpackage, uint forThreads = 0)
  {
    if(__threadId() == 0)
      emitWorkpackage<PROCEDURE>(workpackage, forThreads);
  }
}

#endif //SOFTSHELL_QUEUE_DSCHEDULER_INCLUDED