/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#ifndef SOFTSHELL_QUEUE_QUEUEEENTRY_INCLUDED
#define SOFTSHELL_QUEUE_QUEUEEENTRY_INCLUDED

#include "distributor/deviceentries.h"
#include "tools/types.h"
#include <cstdio>

namespace Softshell
{
  class Workpackage;
  class QueueEntry;

  struct QueueEntryData
  {
    DeviceEntryProcedureFunc func;
    Workpackage* wp;
    uint numThreads;
    __device__ inline const QueueEntryData & operator = (const volatile QueueEntry&);
  };
  struct QueueEntry
  {
    DeviceEntryProcedureFunc func;
    Workpackage* wp;
    uint numThreads;
    int state;

    __device__ inline const volatile QueueEntry & operator= (const QueueEntryData& other) volatile
    {
      func = other.func;
      wp = other.wp;
      numThreads = other.numThreads;
      return *this;
    }
    __device__ void init() volatile
    {
      state = 0;
    }
    __device__ void acquire() volatile
    {
      uint coco = 0;
      while(state != 0)
        if(++coco > 1000000)
        {
          printf("could not acquire Queue Element!\nABORT\n");
          trap();
        }
    }
    __device__ void ready() volatile
    {
      state = 1;
    }
    __device__ bool isReady() volatile
    {
      return state == 1;
    }
    __device__ void read() volatile
    {
      uint coco = 0;
      while(state != 1)
        if(++coco > 1000000)
        {
          printf("could not acquire Queue Element!\nABORT\n");
          trap();
        }

    }
    __device__ void free() volatile
    {
      state = 0;
    }
  };


  __device__ inline const QueueEntryData & QueueEntryData::operator= (const volatile QueueEntry& other)
  {
    func = other.func;
    wp = other.wp;
    numThreads = other.numThreads;
    return *this;
  }
}


#endif
