/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#ifndef ASMS_CUH
#define ASMS_CUH

namespace std_gpu
{
  typedef unsigned int uint;
  namespace
  {
    template<size_t Psize>
    class PointerSize
    {
    public:
      typedef unsigned int type;
    };
    template<>
    class PointerSize<8>
    {
    public:
      typedef unsigned long long int type;
    };

    typedef PointerSize<sizeof(char*)>::type PointerEquivalent;
  }

#if defined(__CUDACC__)
  __device__ inline unsigned int laneid()
  {
    uint mylaneid;
    asm("mov.u32 %0, %laneid;" : "=r" (mylaneid));
    return mylaneid;
  }
  //requires ptx isa 1.3
  __device__ inline uint warpid()
  {
    uint mywarpid;
    asm("mov.u32 %0, %warpid;" : "=r" (mywarpid));
    return mywarpid;
  }
  __device__ inline uint nwarpid()
  {
    uint mynwarpid;
    asm("mov.u32 %0, %nwarpid;" : "=r" (mynwarpid));
    return mynwarpid;
  }
  //requires ptx isa 1.3
  __device__ inline uint smid()
  {
    uint mysmid;
    asm("mov.u32 %0, %smid;" : "=r" (mysmid));
    return mysmid;
  }

  //requires ptx isa 2.0 and sm_20
  __device__ inline uint nsmid()
  {
    uint mynsmid;
    asm("mov.u32 %0, %nsmid;" : "=r" (mynsmid));
    return mynsmid;
  }
  //requires ptx isa 2.0 and sm_20
  __device__ inline uint lanemask()
  {
    uint lanemask;
    asm("mov.u32 %0, %lanemask_eq;" : "=r" (lanemask));
    return lanemask;
  }
    //requires ptx isa 2.0 and sm_20
  __device__ inline uint lanemask_le()
  {
    uint lanemask;
    asm("mov.u32 %0, %lanemask_le;" : "=r" (lanemask));
    return lanemask;
  }
    //requires ptx isa 2.0 and sm_20
  __device__ inline uint lanemask_lt()
  {
    uint lanemask;
    asm("mov.u32 %0, %lanemask_lt;" : "=r" (lanemask));
    return lanemask;
  }
    //requires ptx isa 2.0 and sm_20
  __device__ inline uint lanemask_ge()
  {
    uint lanemask;
    asm("mov.u32 %0, %lanemask_ge;" : "=r" (lanemask));
    return lanemask;
  }
    //requires ptx isa 2.0 and sm_20
  __device__ inline uint lanemask_gt()
  {
    uint lanemask;
    asm("mov.u32 %0, %lanemask_gt;" : "=r" (lanemask));
    return lanemask;
  }
  //custom sync
  __device__ inline void syncthreads(uint lock = 0, int num = -1)
  {
    if(num == -1)
    {
      asm("bar.sync %0;" : : "r"(lock));
    }
    else
    {
      asm("bar.sync %0, %1;" : : "r"(lock), "r"(num));
    }
  }
  __device__ inline void arrive(uint lock, uint num)
  {
    asm("bar.arrive %0, %1;" : : "r"(lock), "r"(num));
  }
#endif

}
#endif //ASMS_CUH