/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#ifndef VECTOR_CUH
#define VECTOR_CUH

namespace std_gpu
{
  //simple vector class
  template<class T>
  class _vector
  {
  protected:
    static const uint MIN_INCREASE = 8;
    static const uint MAX_INCREASE = 256;

    T* _data;
    uint _capacity;
    uint _size;

    __device__ inline void alloc(uint n, T d = T())
    {
      T* ndata = new T[n];
      for(uint i = 0; i < _size; ++i)
        ndata[i] = _data[i];
      for(uint i = _size; i < n; ++i)
        ndata[i] = d;
      if(_data) delete[] _data;
      _data = ndata;
      _capacity = n;
    }
    __device__ inline void enlarge()
    {
      uint n = _capacity*2;
      n = min(max(n,_capacity+MIN_INCREASE),_capacity+MAX_INCREASE);
      alloc(n);
    }
  public:
    __device__ inline void clear() { _size = 0; }
    __device__ inline void init() { _data = 0; _capacity = 0; _size = 0; }
    __device__ inline void destroy() { if(_data) delete[] _data; }
    __device__ inline uint size() const { return _size; }
    __device__ inline void resize(uint n, T d = T()) { if(n > _capacity) alloc(n,d); _size = n; }
    __device__ inline void reserve(uint n) { if(n > _capacity) alloc(n); }
    __device__ inline T* push_back(const T& t) { if(_capacity <= _size) enlarge(); _data[_size] = t; return _data + _size++; }
    __device__ inline void pop_back() { if(_size > 0) --_size; }
    __device__ inline T* back() { if(_size > 0) return &_data[_size-1]; return 0; }
    __device__ inline T& operator[] (uint i) { return _data[i]; }
  };
  template<class T>
  class vector : public _vector<T>
  {
  public:
    __device__ inline vector() { _vector<T>::_data = 0; _vector<T>::_capacity = 0; _vector<T>::_size = 0; }
    __device__ inline vector(const vector& other)
    {
      _vector<T>::_capacity = other._capacity;
      _vector<T>::_size = other._size;
      _vector<T>::_data = new T[_vector<T>::_capacity];
      for(uint i = 0; i < _vector<T>::_size; ++i)
        _vector<T>::_data[i] = other._vector<T>::_data[i];
    }
    __device__ inline ~vector() { _vector<T>::destroy(); }
  };
}

#endif
