/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#include "timing/timesync.h"
#include "tools/utils.h"
#include "distributor/device.h"
#include "communicator/hcommunicator.h"

namespace Softshell
{

  void initTimeSync(int mpc, int grid, double clockrate);

  TimeSync::PointInTime TimeSync::t0;

  int TimeSync::execute()
  {
    CUDA_CHECKED_CALL(cudaSetDevice(device->deviceId()));
    cudaDeviceProp deviceProps;
    CUDA_CHECKED_CALL(cudaGetDeviceProperties(&deviceProps, device->deviceId()));

    int mpc = deviceProps.multiProcessorCount;
    int grid = deviceProps.maxThreadsPerMultiProcessor*deviceProps.multiProcessorCount/32;
    clockrate = deviceProps.clockRate*1000.0; //kHz->Hz

    initTimeSync(mpc, grid, clockrate);
    startsignal.signal();
    while(run)
    {
      if(pausing)
      {
        signal.wait();
        if(!run) return 0;
      }
      unsigned long long curr = getTimeCycles();
      device->getCommunicator()->send(H2D_TimePulse, sizeof(unsigned long long), reinterpret_cast<uint*>(&curr));
      signal.wait(PulseInterval);
    }
    return 0;
  }
}

