/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/


/*
* file created by    Markus Steinberger / steinberger ( at ) icg.tugraz.at
*
* modifications by
*/

#ifndef SOFTSHELL_TIMING_TIMESYNC_CUH_INCLUDED
#define SOFTSHELL_TIMING_TIMESYNC_CUH_INCLUDED

#include "tools/common.cuh"

namespace Softshell
{

  const double INF_TIME = 1.0e300;

  const uint TIMESYNC_buffersize = 128;
  //TODO the following two should be __constant__ ... but linker screws it up!
  extern __device__  clock64_t TIMESYNC_mp_cycle_offset[TIMESYNC_buffersize];
  extern __device__ double TIMESYNC_max_seconds_per_cycle;


  extern __device__ double TIMESYNC_seconds_per_cycle;
  extern __device__ clock64_t TIMESYNC_pulse;
  extern __device__ clock64_t TIMESYNC_realpulse;


  __device__ inline clock64_t getTimeCycles()
  {
    uint myid = smid();
    clock64_t cyclecount = __clock64();
    clock64_t diff = cyclecount - TIMESYNC_mp_cycle_offset[myid];
    return diff;
  }
  __device__ inline double getTime()
  {
    clock64_t diff = getTimeCycles();
    return TIMESYNC_realpulse*TIMESYNC_max_seconds_per_cycle + (diff - TIMESYNC_pulse)*TIMESYNC_seconds_per_cycle;
  }
  __device__ inline double cycleDiffToTime(clock64_t cycles)
  {
    return TIMESYNC_max_seconds_per_cycle*cycles;
  }
}

#endif //TIMESYNC_CUH
