/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

#include "softshell.h"
#include "timing/timesync.h"

#include <iostream>
#include <vector>
#include <fstream>
#include <set>
#include <cstdio>
#include <cstdlib>

#include "mypriority.cuh"
#include "myworkpackage.cuh"
#include "myproc.cuh"

using namespace Softshell;

void runtest(int device)
{
  //setup scheduler with custom priority eval
  Scheduler scheduler(getController<MyPriorityEval,true,true>(), device);
#ifndef WIN32
  PEvent
#else
  auto
#endif
   myevent = scheduler.createEvent<MyWorkpackage, MyProc>();
  //time waited by the procedure (in cycles)
  uint waittime = 500000;


  //experiment with number of sorting threads
  scheduler.setConfigParam("ControllerSortingThreads",128);
  uint num = 4*1024;
  uint* order = 0;
  std::vector<uint> h_order(num,num);
  cudaMalloc(&order, num*sizeof(uint));
  cudaMemcpy(order, &h_order[0], sizeof(uint)*num, cudaMemcpyHostToDevice);
  //custom params
  MyParam param(waittime, order);
  double t0 = TimeSync::time();
  uint id0 = myevent->fire(DefaultCreatorParams<MyParam>(num, 512, param));
  //wait for the event to finish
  myevent->join();
  double t1 = TimeSync::time();

  std::cout << "used the device for " << myevent->getExecTime(id0)*1000 <<"ms CPU was waiting for " << (t1-t0)*1000 << "ms"<< std::endl;


  //get exec order back to cpu
  cudaMemcpy(&h_order[0], order, sizeof(uint)*num, cudaMemcpyDeviceToHost);


  std::ofstream res("sorting.txt", std::ios_base::trunc);
  for(uint i = 0; i < num; ++i)
  {
    uint el = h_order[i];
    if(el >= num)
      std::cout << "workpackage was not executed / or multiple execution: " << i << "\n";
    res << el << " ";
  }
  res.close();
  std::cout << "wrote execution order to 'sorting.txt'" << std::endl;

  scheduler.shutdown();
}
