/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

#include "proc1.cuh"
#include "proc2.cuh"

#include <stdio.h>

using namespace Softshell;

__device__ void MyProc1::execute(Workpackage* workpackage)
{    
  BlockWorkpackage* bwp = static_cast<BlockWorkpackage*>(workpackage);
  if(__threadId() == 0)
    printf("MyProc1 executed with %d threads for BlockWorkpackage %d %d\n",__numThreads(), bwp->blockId.x, bwp->blockId.y);

  //forward the workpackage for execution with proc2 with 256 threads
  emitSingleWorkpackage<MyProc2>(bwp,512);

  // or create a new workpackage via new/delete
  if(__threadId() == 0)
  {
    BlockWorkpackage* nwp = new BlockWorkpackage(workpackage->getEvent(), make_uint3(bwp->blockId.x,bwp->blockId.y,1), 256);
    //emit this workpackage and let the scheduler determine the number of required threads (from the BlockWorkpackage)
    emitWorkpackage<MyProc2>(nwp);
  }

}