/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

#include "proc1.cuh"
#include "proc2.cuh"

#include <stdio.h>

using namespace Softshell;


__device__ void MyProc2::execute(Workpackage* workpackage)
{
  BlockWorkpackage* bwp = static_cast<BlockWorkpackage*>(workpackage);

  //In Softshell you use
    // __threadId()   ... to access the linear thread id within the procedure
    // __numThreads()  ... to get the number of executing thread for this procedure
    // __sync() ... to sync all threads executing this procedure
    // __shared() ... to access the shared memory that has been requested via the Procedure definition



  //this are the 4 uints we wanted for the entire procedure
  uint4* ourshared = (uint4*)__shared();
  ourshared->x = 0;
  ourshared->y = 1;
  ourshared->z = 2;
  ourshared->w = 3;

  //this is the space we wanted for each thread
  uint* perThreadShared = (uint*)(ourshared + 1);
  perThreadShared[__threadId()] = __threadId();
  __sync();

  if(__threadId() == 0)
  {
    printf("MyProc2 executed with %d threads for BlockWorkpackage %d %d %d\n",__numThreads(), bwp->blockId.x, bwp->blockId.y, bwp->blockId.z);
    if(bwp->blockId.z == 1)
      //this workpackage has been created in MyProc1 via new, so we should also free it again
      delete bwp;
  }
}
