/*
  Softshell: Dynamic Scheduling on GPUs.
  http://www.icg.tugraz.at/project/mvp

  Copyright (C) 2012 Institute for Computer Graphics and Vision,
                     Graz University of Technology

  Author(s):  Markus Steinberger - steinberger ( at ) icg.tugraz.at
              Bernhard Kainz - kainz ( at ) icg.tugraz.at
              Michael Kenzel - kenzel ( at ) icg.tugraz.at
              Stefan Hauswiesner - hauswiesner ( at ) icg.tugraz.at
              Bernhard Kerbl - kerbl ( at ) icg.tugraz.at
              Dieter Schmalstieg - schmalstieg ( at ) icg.tugraz.at

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

#include "payloadedproc.cuh"

#include <stdio.h>

using namespace Softshell;

//in class definition (works with MSVC and with up to date GCC versions(as soon as CUDA supports them) )
#if defined(WIN32)
__device__ void MyPayloadedProc::execute(Workpackage* workpackage)
{
   //define additional payload directly in execute
   THIRDTIER_BEGIN
    uint x,y;
    uint startblock;

    //execute code starts here
    THIRDTIER_EXECUTE
      x = __threadId()*100;
      y = 0;
      startblock = blockIdx.x;

      //scheduler is activated every 50th iteration of this loop
      //if the fillrate falls below 70% it tries to combine the data with others
      //the loop is executed until x >= 10000
      SCHEDULEDWHILE(x < 10000, 50, 0.7f)
      {
          ++x;
          ++y;
      }
      volatile MyPayloadedWorkpackage* mywp = static_cast<volatile MyPayloadedWorkpackage*>(workpackage);
      uint customdata = mywp->myCustomData;
      printf("finished workitem with customdata: %d \n\tthe intial thread %d(@block %d) ended as thread %d(@block %d).\n\tthe payload is x: %d y: %d\n",customdata,__initialThreadId(),startblock,__threadId(),blockIdx.x, x,y);

   THIRDTIER_END
}
#else

//out of class definition
THIRDTIER_EXT_BEGIN(MyPayload)
  uint x,y;
  uint startblock;

  //execute code starts here
  THIRDTIER_EXECUTE
    x = __threadId()*100;
    y = 0;
    startblock = blockIdx.x;

    //scheduler is activated every 50th iteration of this loop
    //if the fillrate falls below 70% it tries to combine the data with others
    //the loop is executed until x >= 10000
    SCHEDULEDWHILE_EXT(MyPayload, x < 10000, 50, 0.7f)
    {
        ++x;
        ++y;
    }
    volatile MyPayloadedWorkpackage* mywp = static_cast<volatile MyPayloadedWorkpackage*>(workpackage);
    uint customdata = mywp->myCustomData;
    printf("finished workitem with customdata: %d \n\tthe intial thread %d(@block %d) ended as thread %d(@block %d).\n\tthe payload is x: %d y: %d\n",customdata,__initialThreadId(),startblock,__threadId(),blockIdx.x, x,y);

THIRDTIER_EXT_END

__device__ void MyPayloadedProc::execute(Workpackage* workpackage)
{
   THIRDTIER_EXT_CALLER(MyPayload)
}
#endif