/*
 * Decompiled with CFR 0.152.
 */
package koala;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import koala.KoalaLongRangeSensors;
import koala.KoalaMotors;
import koala.KoalaSensorReading;
import koala.KoalaSensors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Koala
implements KoalaMotors,
KoalaSensors,
KoalaLongRangeSensors {
    public final int WHEELRADIUS = 152;
    private final double RADIAN = 57.2957795;
    private static Koala robot = null;
    private boolean initialised = false;
    private final boolean useJNI;
    private BufferedReader serialReader;
    private PrintWriter serialWriter;
    private SerialPort serialPort;
    private final int WHEELDIAMETER = 320;

    public static Koala getInstance() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("java.rmi.server.hostname");
        if (string.contains("Windows")) {
            return Koala.getInstance("COM1");
        }
        if (string2 != null && string2.equals("das05eee")) {
            return Koala.getInstance("/dev/ttyUSB0");
        }
        if (robot == null) {
            robot = new Koala(true, null);
        }
        return robot;
    }

    public static Koala getInstance(String string) {
        if (robot == null) {
            robot = new Koala(false, string);
        }
        return robot;
    }

    private Koala(boolean bl, String string) {
        this.useJNI = bl;
        if (bl) {
            System.loadLibrary("jkoala");
            this.initialised = this.initialiseKoala() == 0;
        } else {
            try {
                CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string);
                this.serialPort = (SerialPort)commPortIdentifier.open("Koala", 20);
                this.serialPort.setSerialPortParams(115200, 8, 2, 0);
                this.serialPort.disableReceiveTimeout();
                this.serialPort.disableReceiveThreshold();
                this.serialReader = new BufferedReader(new InputStreamReader(this.serialPort.getInputStream()));
                this.serialWriter = new PrintWriter(this.serialPort.getOutputStream());
                this.initialised = true;
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            }
            catch (PortInUseException portInUseException) {
            }
            catch (NoSuchPortException noSuchPortException) {
                // empty catch block
            }
        }
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    private synchronized native int initialiseKoala();

    public synchronized void disconnect() {
        if (!this.useJNI) {
            this.serialPort.close();
            this.initialised = false;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.useJNI) {
                this.serialPort.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    private Vector<String> readLine() {
        Vector<String> vector = null;
        for (int i = 0; vector == null && i < 2; ++i) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(this.serialReader.readLine(), ",");
                vector = new Vector<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    vector.add(stringTokenizer.nextToken());
                }
                if (vector.size() != 0) continue;
                vector = null;
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (vector == null) {
            System.out.println("Koala: HARDWARE NOT RESPONDING.");
            System.exit(-1);
        }
        return vector;
    }

    private void writeLine(String string) {
        this.serialWriter.println(string);
        this.serialWriter.flush();
    }

    private synchronized native String getSoftwareVersionN();

    @Override
    public synchronized String getSoftwareVersion() {
        if (this.useJNI) {
            return this.getSoftwareVersionN();
        }
        this.writeLine("B");
        Vector<String> vector = this.readLine();
        return "OS revision " + vector.elementAt(1) + " Protocol " + vector.elementAt(2);
    }

    private synchronized native int getTemperatureN();

    @Override
    public synchronized int getTemperature() {
        if (this.useJNI) {
            return this.getTemperatureN();
        }
        this.writeLine("M,2");
        String string = this.readLine().elementAt(1);
        return Integer.parseInt(string) / 10;
    }

    private synchronized native int getBatteryTemperatureN();

    @Override
    public synchronized int getBatteryTemperature() {
        if (this.useJNI) {
            return this.getBatteryTemperatureN();
        }
        this.writeLine("M,5");
        String string = this.readLine().elementAt(1);
        return Integer.parseInt(string) / 10;
    }

    private synchronized native int getBatteryChargeN();

    @Override
    public synchronized int getBatteryCharge() {
        if (this.useJNI) {
            return this.getBatteryChargeN();
        }
        this.writeLine("S");
        String string = this.readLine().elementAt(1);
        return Integer.parseInt(string);
    }

    private synchronized native int getBatteryTimeLeftN();

    @Override
    public synchronized int getBatteryTimeLeft() {
        if (this.useJNI) {
            return this.getBatteryTimeLeftN();
        }
        return this.getBatteryCharge() * 60 / this.getConsumptionCurrent();
    }

    private synchronized native int getBatteryVoltageN();

    @Override
    public synchronized int getBatteryVoltage() {
        if (this.useJNI) {
            return this.getBatteryVoltageN();
        }
        this.writeLine("M,0");
        String string = this.readLine().elementAt(1);
        return Integer.parseInt(string) * 20;
    }

    private synchronized native int getConsumptionCurrentN();

    @Override
    public synchronized int getConsumptionCurrent() {
        if (this.useJNI) {
            return this.getConsumptionCurrentN();
        }
        this.writeLine("M,1");
        String string = this.readLine().elementAt(1);
        return Integer.parseInt(string) * 8;
    }

    private synchronized native int getLeftMotorCurrentN();

    @Override
    public synchronized int getLeftMotorCurrent() {
        if (this.useJNI) {
            return this.getLeftMotorCurrentN();
        }
        this.writeLine("M,3");
        String string = this.readLine().elementAt(1);
        return Integer.parseInt(string) * 4;
    }

    private synchronized native int getRightMotorCurrentN();

    @Override
    public synchronized int getRightMotorCurrent() {
        if (this.useJNI) {
            return this.getRightMotorCurrentN();
        }
        this.writeLine("M,4");
        String string = this.readLine().elementAt(1);
        return Integer.parseInt(string) * 4;
    }

    private synchronized native int setLEDStateN(int var1, int var2);

    @Override
    public synchronized int setLEDState(int n, int n2) {
        if (this.useJNI) {
            return this.setLEDStateN(n, n2);
        }
        this.writeLine("L," + n + "," + n2);
        String string = this.readLine().elementAt(0);
        if (string.equals("l")) {
            return 0;
        }
        return 1;
    }

    private synchronized native int turnLEDOnN(int var1);

    @Override
    public synchronized int turnLEDOn(int n) {
        if (this.useJNI) {
            return this.turnLEDOnN(n);
        }
        return this.setLEDState(n, 1);
    }

    private synchronized native int turnLEDOffN(int var1);

    @Override
    public synchronized int turnLEDOff(int n) {
        if (this.useJNI) {
            return this.turnLEDOffN(n);
        }
        return this.setLEDState(n, 0);
    }

    private synchronized native int setSpeedN(int var1, int var2);

    @Override
    public synchronized int setSpeed(int n, int n2) {
        if (this.useJNI) {
            return this.setSpeedN(n, n2);
        }
        this.writeLine("D," + n + "," + n2);
        String string = this.readLine().elementAt(0);
        if (string.equals("d")) {
            return 0;
        }
        return 1;
    }

    private synchronized native int getLeftMotorSpeedN();

    @Override
    public synchronized int getLeftMotorSpeed() {
        if (this.useJNI) {
            return this.getLeftMotorSpeedN();
        }
        this.writeLine("E");
        String string = this.readLine().elementAt(1);
        return Integer.parseInt(string);
    }

    private synchronized native int getRightMotorSpeedN();

    @Override
    public synchronized int getRightMotorSpeed() {
        if (this.useJNI) {
            return this.getRightMotorSpeedN();
        }
        this.writeLine("E");
        String string = this.readLine().elementAt(2);
        return Integer.parseInt(string);
    }

    private synchronized native int setMotorPositionN(int var1, int var2);

    @Override
    public synchronized int setMotorPosition(int n, int n2) {
        if (this.useJNI) {
            return this.setMotorPositionN(n, n2);
        }
        this.writeLine("C," + n + "," + n2);
        String string = this.readLine().elementAt(0);
        if (string.equals("c")) {
            return 0;
        }
        return 1;
    }

    private synchronized native int getLeftMotorPositionN();

    @Override
    public synchronized int getLeftMotorPosition() {
        if (this.useJNI) {
            return this.getLeftMotorPositionN();
        }
        this.writeLine("H");
        String string = this.readLine().elementAt(1);
        return Integer.parseInt(string);
    }

    private synchronized native int getRightMotorPositionN();

    @Override
    public synchronized int getRightMotorPosition() {
        if (this.useJNI) {
            return this.getRightMotorPositionN();
        }
        this.writeLine("H");
        String string = this.readLine().elementAt(2);
        return Integer.parseInt(string);
    }

    private synchronized native int readAnalogueInputN(int var1);

    @Override
    public synchronized int readAnalogueInput(int n) {
        if (this.useJNI) {
            return this.readAnalogueInputN(n);
        }
        this.writeLine("I," + n);
        String string = this.readLine().elementAt(1);
        return Integer.parseInt(string);
    }

    private synchronized native int readDigitalInputN(int var1);

    @Override
    public synchronized int readDigitalInput(int n) {
        if (this.useJNI) {
            return this.readDigitalInputN(n);
        }
        this.writeLine("Y," + n);
        String string = this.readLine().elementAt(1);
        return Integer.parseInt(string);
    }

    private synchronized native int setDigitalOutputN(int var1, int var2);

    @Override
    public synchronized int setDigitalOutput(int n, int n2) {
        if (this.useJNI) {
            return this.setDigitalOutputN(n, n2);
        }
        this.writeLine("Q," + n + "," + n2);
        String string = this.readLine().elementAt(0);
        if (string.equals("q")) {
            return 0;
        }
        return 1;
    }

    private synchronized native KoalaSensorReading readProximitySensorsN();

    @Override
    public synchronized KoalaSensorReading readProximitySensors() {
        if (this.useJNI) {
            return this.readProximitySensorsN();
        }
        this.writeLine("N");
        KoalaSensorReading koalaSensorReading = new KoalaSensorReading();
        Vector<String> vector = this.readLine();
        for (int i = 1; i < vector.size(); ++i) {
            if (i < 9) {
                koalaSensorReading.leftSensors[i - 1] = Integer.parseInt(vector.elementAt(i));
                continue;
            }
            koalaSensorReading.rightSensors[i - 9] = Integer.parseInt(vector.elementAt(i));
        }
        return koalaSensorReading;
    }

    private synchronized native KoalaSensorReading readAmbientSensorsN();

    @Override
    public synchronized KoalaSensorReading readAmbientSensors() {
        if (this.useJNI) {
            return this.readAmbientSensorsN();
        }
        this.writeLine("O");
        KoalaSensorReading koalaSensorReading = new KoalaSensorReading();
        Vector<String> vector = this.readLine();
        for (int i = 1; i < vector.size(); ++i) {
            if (i < 9) {
                koalaSensorReading.leftSensors[i - 1] = Integer.parseInt(vector.elementAt(i));
                continue;
            }
            koalaSensorReading.rightSensors[i - 9] = Integer.parseInt(vector.elementAt(i));
        }
        return koalaSensorReading;
    }

    private synchronized native boolean leftMotorErrorN();

    @Override
    public synchronized boolean leftMotorError() {
        if (this.useJNI) {
            return this.leftMotorErrorN();
        }
        this.writeLine("K");
        String string = this.readLine().elementAt(3);
        return string.equals("1");
    }

    private synchronized native boolean rightMotorErrorN();

    @Override
    public synchronized boolean rightMotorError() {
        if (this.useJNI) {
            return this.rightMotorErrorN();
        }
        this.writeLine("K");
        String string = this.readLine().elementAt(6);
        return string.equals("1");
    }

    @Override
    public synchronized int moveForward(double d) {
        int n = d > 0.0 ? 1 : -1;
        int n2 = this.setSpeed(15 * n, 15 * n);
        if (n2 < 0) {
            this.setSpeed(0, 0);
            return n2;
        }
        try {
            Thread.sleep((int)Math.round(1000.0 * d * (double)n / 67.5));
        }
        catch (Exception exception) {
            System.err.println("Thread interrupted during Koala.moveForward.");
        }
        n2 = this.setSpeed(0, 0);
        if (n2 < 0) {
            return n2;
        }
        return 0;
    }

    @Override
    public synchronized int rotate(double d) {
        int n = d > 0.0 ? 1 : -1;
        double d2 = 955.044166691297 * (d / 360.0);
        int n2 = this.setSpeed(-15 * n, 15 * n);
        if (n2 < 0) {
            this.setSpeed(0, 0);
            return n2;
        }
        try {
            Thread.sleep((int)Math.round(1000.0 * d2 * (double)n / 67.5));
        }
        catch (Exception exception) {
            System.err.println("Thread interrupted during Koala.rotate.");
        }
        n2 = this.setSpeed(0, 0);
        if (n2 < 0) {
            return n2;
        }
        return 0;
    }

    public synchronized void rotate(int n, double d) {
        double d2 = 57.2957795;
        int n2 = (int)Math.round(1000.0 * d / d2);
        this.setSpeed(n, d2);
        try {
            Thread.sleep(n2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setSpeed(0, 0);
    }

    public synchronized void setSpeed(int n, double d) {
        int n2 = n < 0 ? -1 : 1;
        int n3 = (int)Math.round((d /= 57.2957795) * ((double)(n *= n2) + 160.0) / 4.5);
        int n4 = (int)Math.round(d * ((double)n - 160.0) / 4.5);
        if (n2 == 1) {
            this.setSpeed(n4, n3);
        } else {
            this.setSpeed(n3, n4);
        }
    }

    public synchronized double getAngularVelocity() {
        return 257.83100775 * (double)(this.getRightMotorSpeed() - this.getLeftMotorSpeed()) / 320.0;
    }

    private synchronized native void printFPN(double var1);

    public synchronized void printFP(double d) {
        if (this.useJNI) {
            this.printFPN(d);
        } else {
            System.out.println(d);
        }
    }

    public synchronized double getRadiusOfRotation() {
        double d;
        double d2 = this.getRightMotorSpeed();
        if (d2 == (d = (double)this.getLeftMotorSpeed())) {
            return Double.POSITIVE_INFINITY;
        }
        return 160.0 * ((d2 + d) / (d2 - d));
    }

    private synchronized native KoalaSensorReading readLongRangeSensorsN();

    @Override
    public synchronized KoalaSensorReading readLongRangeSensors() {
        if (this.useJNI) {
            return this.readLongRangeSensorsN();
        }
        this.writeLine("V");
        KoalaSensorReading koalaSensorReading = new KoalaSensorReading();
        Vector<String> vector = this.readLine();
        koalaSensorReading.leftSensors[0] = Integer.parseInt(vector.elementAt(2));
        koalaSensorReading.leftSensors[1] = Integer.parseInt(vector.elementAt(1));
        koalaSensorReading.rightSensors[0] = Integer.parseInt(vector.elementAt(4));
        koalaSensorReading.rightSensors[1] = Integer.parseInt(vector.elementAt(3));
        return koalaSensorReading;
    }

    @Override
    public synchronized int readFrontLeftLRSensor() {
        return this.readLongRangeSensors().leftSensors[0];
    }

    @Override
    public synchronized int readFrontRightLRSensor() {
        return this.readLongRangeSensors().rightSensors[0];
    }

    @Override
    public synchronized int readLeftSideLRSensor() {
        return this.readLongRangeSensors().leftSensors[1];
    }

    @Override
    public synchronized int readRightSideLRSensor() {
        return this.readLongRangeSensors().rightSensors[1];
    }

    @Override
    public synchronized boolean hasLongRangeSensors() {
        KoalaSensorReading koalaSensorReading = this.readLongRangeSensors();
        return koalaSensorReading.leftSensors[0] != 255 || koalaSensorReading.leftSensors[1] != 255 || koalaSensorReading.rightSensors[0] != 255 || koalaSensorReading.rightSensors[1] != 255;
    }
}

